/*------------------------------------------------------------------------------
	Function defining the gaussian density function given mean and variance
------------------------------------------------------------------------------*/
#include <math.h>

float gauss(float *x,float *mean, float *invvar, float corprod, int Ndim)
{
  auto int j;
  auto float power = 0, density;
  
  for (j = 0; j < Ndim; ++j)
    power += (x[j] - mean[j]) * (x[j] - mean[j]) * invvar[j];
  power /= -2.0;
  density = corprod + power;
  return (density);
}
