# vts
Vector Taylor Series (VTS) Compensation.
VTS package in C written by Pedro Moreno and Bhiksha Raj. The package includes
two components:
  * `estimate_mixgau` - for GMM estimation
  * `vts_norm`        - VTS compensation

`vts.py` is a Python wrapper written by Raymond Xia (yangyanx@andrew.cmu.edu)
for end-to-end compensation of audio signals.

# Requirement
  * `vts.py` requires `audiolib`.

# Installation and Usage of VTS Package in C
To install both components, `cd` to each subdirectory and follow the instruction
in there.

The VTS package only accepts log-spectrogram input files in SPHINX format. There
are two options to obtain files in the SPHINX format:
  1. Use the feature extraction utility `wave2feat` included in the SPHINX
  library.
  2. Use helper function `write_sphinx` included in
  `audiolib/python/audio_io.py`.
  to write a numpy array to a SPHINX-compatible file.

The compensated output file will also be in SPHINX format. In order to read the
file back into a numpy array, use `read_sphinx` included in `audio_io.py`.

Instructions of both components are in the README file in each subdirectory.

# Usage of `vts.py`
To train a GMM of clean speech, run
  ```
  python vts.py -i path/to/clean/speech/corpus -o path/to/model
  ```
By default, the GMM mixture mode is set to 32.

To perform VTS compensation using learned GMM on noisy speech, run
  ```
  python vts.py -i path/to/noisy/speech -o path/to/output -m path/to/model.gmm
  ```
By default, the output is in raw audio. If the 40-channel log-spectrogram is
desired instead, one can change the meta-parameters in `vts.py`.
