# Global configuration parameters for MRNN
config = {
    'white_noise':{
        'TRAIN_DIR': '/Volumes/Data/LDC93S1/TIMITcorpus/TIMIT/TRAIN/',

        # STFT Parameters
        'SAMPLE_RATE': 16000, # in Hz
        'WINDOW_LENGTH': 0.032, # in seconds
        'FFT_SIZE': 512, # in number of samples
        'HOP_FRACTION': 0.5,

        # Neural Nets Parameters
        'FREQ_DIM': 257,
        'MINIBATCH_SIZE': 1000,
        'LEARNING_RATE': 1e-3,
        'HIDDEN_DIM': 256,
        'NEPOCH': 20,
        'PRINT_EVERY': 20,
        'BPTT_TRUNCATE': 10
    },

    'rats':{
        'RATS_A': '/Volumes/Data/LDC2015S02/RATS_SAD/data/aligned-dev-1/audio/A/',
        'RATS_H': '/Volumes/Data/LDC2015S02/RATS_SAD/data/aligned-dev-1/audio/H/',
        'RATS_D':'/Volumes/Data/LDC2015S02/RATS_SAD/data/aligned-dev-2/audio/D_reliable/',
        'SRC_AUD':
        '/Volumes/Data/LDC2015S02/RATS_SAD/data/dev-1/audio/src/',
        'SRC_AUD2':'/Volumes/Data/LDC2015S02/RATS_SAD/data/dev-2/audio/src/',
        'SRC_SAD': '/Volumes/Data/LDC2015S02/RATS_SAD/data/dev-1/sad/src/',
        'SRC_SAD2': '/Volumes/Data/LDC2015S02/RATS_SAD/data/dev-2/sad/src/',
        # STFT Parameters
        'SAMPLE_RATE': 16000, # in Hz
        'WINDOW_LENGTH': 0.032, # in seconds
        'FFT_SIZE': 512, # in number of samples
        'HOP_FRACTION': 0.25,
        'ZERO_PHASE_STFT': True, # use new zero-phase STFT

        # Neural Nets Parameters
        'FREQ_DIM': 257,
        'LEARNING_RATE': 0,
        'HIDDEN_DIM': 257, # 1.5 * FREQ_DIM
        'NEPOCH': 20, # 12th model produces better result than final model
        'PRINT_EVERY': 20,
        'BPTT_TRUNCATE': 10,
        'RMSPROP_DECAY': 0.9,

        # Other training data parameters
        'MINIBATCH_SIZE': 10, # number of audio segments/minibatch
        'EXAMPLE_SIZE': 100,   # number of snippets/audio segment drawn
        'EXAMPLE_LENGTH': .32,  # number of seconds/snippet
        'TYPE_RATIO': (.5,.5), # example ratio for (noise,speech,noisy speech)
        'BETA': 1., # cost weighting coefficient in range [0,1]

        # Enable for wiener filtering-like training
        'WIENER': False

        # Memory consumption calculation:
        # Total amount of memory allocated for one batch =
        # MINIBATCH_SIZE * EXAMPLE_SIZE *
        # ((EXAMPLE_LENGTH/(WINDOW_LENGTH*HOP_FRACTION))*FREQ_DIM) * 4 bytes/number * 2
        # 100*10*(.16/(0.032*0.25)*257)*4*2 = 41120000 bytes
    }
}
