// Class Code Set 21
// There is stuff in here that we did not cover
// but you can probably figure it out.  The sounds are fake
// because of copyright issues that are related to my posting
// this on a public web page.  You can find sound files on the
// web.  I have usd soundjay.com.   They are free as long as
// you do not sell your code and do not post it on the web.

// I have added some comments to help you.  The one thing you will see
// is that there are multiple ways to play the sound.  You choose the one that
// gives you the best response.

// Sound test
PFont f;

//audio
import ddf.minim.*;

//These are variables similar float but they have values and functions.
//They are called objects.
//In order to use an object there is some new syntax call the dot operator that is required
//which is a period.  The name of object such as minim or s1 goes first and then a period and
//then the data or the function that you want to use.
Minim minim;
AudioPlayer s1, s2, s3, s4, s5;


void setup( )
{
   size( 400, 400 );
   f = loadFont( "f.vlw" );
   textFont( f, 24 );
   textAlign(CENTER);
  // audio
  // this is new for you -- it "builds" the minim object so you can use it to play sound
  minim = new Minim(this);
  s1 = minim.loadFile("t1.wav");
  s2 = minim.loadFile("t2.wav"); 
  s3 = minim.loadFile("t3.wav");
  s4 = minim.loadFile("t4.wav");
  s5 = minim.loadFile("t5.wav", 1024);
}


void draw( )
{
   drawSquares( );
}

void drawSquares( )
{
    textSize( 24 );
    fill( 255, 0, 0 );
    rect( 0, 0, width/2, height/2);
    fill( 0 );
    text( "Bang", width/2/2, height/2/2 );
    
    fill( 0, 255, 0 );
    rect( width/2, 0, width/2, height/2);
    fill( 0 );
    text( "Screech", width/2+width/2/2, height/2/2 );
    
    fill( 0, 0, 255 );
    rect( 0, height/2, width/2, height/2);
    fill( 0 );
    text( "Boom", width/2/2, height/2+height/2/2 );
    
    fill( 255, 255, 0);
    rect( width/2, height/2, width/2, height/2);
    fill( 0 );
    text( "Thud", width/2+width/2/2, height/2+height/2/2 );
    
    fill( 0, 255, 255 );
    ellipse( width/2, height/2, width*.2, height*.2);
    fill( 0 );
    textSize( 12 );
    text( " Hold\nButton\nDown\nBoink", width/2, height*.45);
   
}

void mousePressed( )
{
   if ( dist( mouseX, mouseY, width/2, height/2) < width*.1 )
   { 
        s5.loop( );  // play the sound s5 in a loop  -- one way to play a sound
   }
   else if ( mouseX < width/2)
   {
     if (mouseY < height/2)
     {
       s1.play( );     // play the sound s1 one time and stop
       s1 = minim.loadFile("t1.wav");  // reload s1 so you can play it again  -- anothe way to play a sound
     }
     else
     {
       s2.play( );
       s2 = minim.loadFile("t2.wav"); 
     }
   }
   else
   {
    if (mouseY < height/2)
     {
       s3.play( );
       s3 = minim.loadFile("t3.wav");
     }
     else
     {
       s4.play( );
       s4 = minim.loadFile("t4.wav");
     }     
   }
}

void mouseReleased( )
{
   s5.pause( );
   s5.rewind( ); // anothe way to reset a sound -- similar to loadFile
}

// Processing calls this -- you do not
void stop( )
{
   // always close audio I/O classes
  s1.close();
  s2.close();
  s3.close();
  s4.close();
  s5.close();
  // always stop your Minim object
  minim.stop();
  super.stop(); 

}
