
//Wrap And Bounce
//Use control of wrapping
//Collision checking
//Day 5 App Lab
//QVHS and MHS

// Your task is to add vertical bouncing and horizontal wrapping and 
// horiziontal mouse control to the wrapping picture.


float x, y, deltaX, deltaY;
float px, py, deltaPY, deltaPX;
float changeAmount, collisionDistance;
PImage p;

int score;



void setup( )
{
  size( 400, 400 );
  
  imageMode( CENTER );
  
  noStroke( );
  
  textSize( 18 );
  textAlign( CENTER );
  
  p = loadImage( "Jim.jpg");
  
  x = 0;
  y = height/2;
  
  px = width/2;
  py = height/2;
  
  deltaX = 3;
  deltaY = 2;
  
  deltaPY = 0;
  deltaPX = 0;
  
  changeAmount = 0.1;
  collisionDistance = 30;
  
  score = 0;
}

void draw( )
{
  prepareScreen( );
  
  showInformation( );
  drawBouncingFigure( );
  drawWrappingFigure( );
  
  changeBouncingFigure( );
  changeWrappingFigure( );   
 
  checkCollision( ); 
}

void showInformation( )
{
  fill( 0 );
  text( "Move the mouse to steer the picture.\nTry to collide with the ball.",
           width/2, 50 );
           
  text( "Score: " + score, width/2, height-50 );
  text( "Time: " + millis( )/1000, width/2, height-25 );
}

void checkCollision( )
{
     // dist function returns distance beetween two points
   float distance = dist( x, y, px, py );
   if ( distance < collisionDistance )
   {
      fill( 0 );
      rect( 0, 0, width, height );
        // We change the position and speed of the bouncing ball with
        // the random function which returns a random number with a 
        // value that is between the arguments.
      x = random( 30, width-30);
      y = random( 30, height-30);
      deltaX = random( 3, 10 );
      deltaY = random( 3, 10 );
      score = score + 1;
   } 
}

  // This is an event function.  When you move the mouse,
  // Processing executes this funtion.  We DO NOT call it.
  // Processing does.
  // We use this to see which direction the user moved the mouse.
  // pmouseX and pmouseY marks the location of the mouse in the last frame.
  // mouseX and mouseY marks the location of the mouse in this frame.
void mouseMoved( )
{
   if ( mouseY < pmouseY )  // mouse moved up
   {
      deltaPY = deltaPY - changeAmount;
   } 
   if ( mouseY > pmouseY )  // mouse moved down
   {
      deltaPY = deltaPY + changeAmount;
   } 
   
   if ( mouseX < pmouseX )  // mouse moved left
   {
      deltaPX = deltaPX - changeAmount;
   } 
   if ( mouseX > pmouseX )  // mouse moved right
   {
      deltaPX = deltaPX + changeAmount;
   }    
}

void prepareScreen( )
{
  fill( 200, 200, 0, 30 );  
  rect(0, 0, width, height);
}

void drawBouncingFigure( )
{
  fill( 200, 0, 0 );  
  ellipse( x, y, 33, 22 );
}

void drawWrappingFigure( )
{
   fill( 0, 0, 200 );
   ellipse( px, py, 40, 40 );
   image ( p, px, py, 30, 30 ); 
}

void changeBouncingFigure( )
{
  // horizontal movement
  x = x + deltaX; 
  if( x > width )  // too far right
  {
     deltaX = -deltaX;  // move to the left
  }
    
  if ( x < 0 )  // too far left
  {
    deltaX = -deltaX;  // move to the right
  }
  
  // vertical movement
  y = y + deltaY; 
  if( y > height )  // too far down
  {
     deltaY = -deltaY;  // move up
  }
    
  if ( y < 0 )  // too far up
  {
    deltaY = -deltaY;  // move down
  }
}

void  changeWrappingFigure( )
{
   println( deltaPY + "  " + deltaPX );
  // vertical wrapping motion
   py = py + deltaPY;
   if ( py > height + 40 )  // picture is too low
   {
      py = -40;   // put the picture above the top edge
      score = 0;
   }
   if ( py < -40 )  // picture is too high
   {
      py = height + 40;  // put the picture below the bottom edge
      score = 0;
   }  
   
   // horizontal wrapping motion
   px = px + deltaPX;
   if ( px > width + 40 )  // picture is too far right
   {
      px = -40;   // put the picture on the left side
      score = 0;
   }
   if ( px < -40 )  // picture is too far right
   {
      px = height + 40;  // put the picture on the right side
      score = 0;
   }  
   
}



