/*
MovementAndPicture
Day 2 App Lab
QVHS and MHS

Refer to the Processing API for an explanation of any of the
Processing functions that are called here that you do not
understand or have never used.

====================================================
If you lined Jim's picture up with the red ellipse, the
ellipe goes behind the picture.  See if you can edit the 
code in the draw( ) function to make the red ellipse go
on top of Jim's picture.
====================================================
This program does two things:
 1 - It imports a picture (.jpg) and displays it wherever 
 the mouse is (Processing variables mouseX and mouseY).
 2 - It moves an ellipse from left to right (a motion we call
 wrapping) at an increasing speed until the ellipse begins to
 move too fast when it slows down.
*/


/*
These are OUR variables, not Processings.  The variable x is
used for the horizontal position of the center of an ellipse 
and the variable y is used for the vertical position of thecenter.

The variable deltaX is the SPEED of the ellipse.  This amount will
be added to the variable x each frame.
*/
float x, y;
float deltaX;

// This is the program's name for the picture
PImage p;

/*
This is the DEFINITION of the function setup( ).
Processing executes this function first and does it ONE time.
We can put any "legal" code here that we need.  
The setup() function should "set the stage" for our program to run.
*/
void setup( )
{
  // This sets the size of the window which is 400 pixels wide
  // and 200 pixels high.  It also sets Processing variable width
  // to 400 and height to 200.
  size( 400, 200 );
  
  // The next line tells Processing to use the center of the
  // picture as its (x, y) location instead of the upper left corner.
  imageMode( CENTER );
  
  // This turns of the black outline around the shapes.
  noStroke( );
  
  /*
  For this to work, you need a folder inside the folder containing
  this file named data.  In that folder you must have a picture
  file named Jim.jpg.
  The next line literally connects the program's name for the
  picture ( p ) with the actual picture file ( Jim.jpg ).
  The name of the file must be spelled here EXACTLY as it is named!
  */
  p = loadImage( "Jim.jpg");
  
  x = 0;
  
  // height has a value equal to the height of the window.
  // The next line gives the variable y the value of the
  // height of the window divided by 2 or one/half of the 
  // height of the window.
  y = height/2;
  
  deltaX = 1;
}

// Processing executes this function 60 times a second
void draw( )
{
  // The next two lines hide the previous frame with
  // a yellow rectangle that covers the entire window.
  // The fourth argument (10) makes the color a bit transparent
  // so we can see parts of the previous frames.
  // ----------------vv----  this is the transparency argument.
  fill( 200, 200, 0, 30 );
  
  // The variables width and height are Processing variables that
  // store the width and height of the graphics window.
  rect(0, 0, width, height);
  
  // The next two lines fill and draw an ellipse at the
  // location (x, y, which are our variables.
  fill( 200, 0, 0 );  
  // The ellipse is slightly flattened to add to the illusion
  // of movement.
  ellipse( x, y, 33, 22 );

  // the next line draws picture, p at the location of the 
  // mouse which is stored in Processing variables mouseX and
  // mouseY.  The picture will be drawn 50 pixels wide and  
  // 50 pixels high
  image( p, mouseX, mouseY, 50, 50 );
  
  // The next line adds the value of the variable deltaX to the 
  // value of the varible x.  This will cause the next frame
  // to draw the picture further to the right giving the 
  // illusion of motion.
  x = x + deltaX;
  
  /*
  If we keep moving the picture to the right, it will eventuall
  disappear beyond the right edge.  The next set of code asks a 
  question, "Is the picture past the right edge?"  If this is 
  true, the value of the variable x (which is used to locate the
  picture) is reset  to zero which is the left edge of the window
  AND
  it increases the value of the variable deltaX so the picture
  moves a bit faster.
  */  
  if( x > width )
  {
    x = 0;
    deltaX = deltaX + 1;
  }
  
  /*
  If we keep increasing the speed, the movement becomes ugly
  so the next set of lines ask the question, "Is the value of
  deltaX too big?"  If it is, the value is reset to 1.
  */
  if( deltaX > 50 )
  {
     deltaX = 1;
  } 
}



