
//Wrap And Bounce
//Day 5 App Lab
//MHS

// changes for today:
//  added other movement direcitons
//  added time limit
//  and increased difficulty of control
//  as score increases

//  Enhancments were Mars students' suggestions.

// ball variables
float bx, by, deltaBX, deltaBY;

// picture variables
float px, py, deltaPY, deltaPYChange, deltaPX, deltaPXChange;
PImage p;

float collisionDistance;

int score;

void setup( )
{
  size( 400, 400 );
  
  imageMode( CENTER );
  
  noStroke( );
  
  textSize( 28 );
  textAlign( CENTER );
  
  // ball variables
  bx = 0;
  by = height/2;
  deltaBX = 9;
  deltaBY = 5;  
  
  // picture variables
  p = loadImage( "Jim.jpg"); 
  px = width/2;
  py = height/2;
  deltaPY = 0;  
  deltaPYChange = 0.1;
  deltaPXChange = 0.1;
  
  collisionDistance = 30;
  
  score = 0;
}

void draw( )
{
  if ( millis( ) < 30000 )
  {
    prepareScreen( );
    
    drawBouncingFigure( );
    
    drawWrappingFigure( );
     
    changeBouncingFigure( );
     
    changeWrappingFigure( );
    
    checkCollision( );
  }
  else
  {
    gameOver( );
  }
}

void gameOver( )
{
  fill( 200, 0, 30 );  
  rect(0, 0, width, height);
  fill( 0 );
  text( "Score: " + score, width/2, 50 );
  text( "Time: " + 30, width/2, height-50 );
  textSize( 60 );
  fill( 0, 0, 200 );
  text( "Game Over", width/2, height/2 );
  noLoop( );
}

void mouseMoved( )
{
   // vertical stuff
  if( mouseY > pmouseY )
  {
    deltaPY = deltaPY + deltaPYChange;
    //println( deltaPY );
  }
  
  if ( mouseY < pmouseY )
  {
     deltaPY = deltaPY - deltaPYChange;
  }
  
  
  // horizontal stuff
  if( mouseX > pmouseX )
  {
    deltaPX = deltaPX + deltaPXChange;
    //println( deltaPY );
  }
  
  if ( mouseX < pmouseX )
  {
     deltaPX = deltaPX - deltaPXChange;
  }
}

void checkCollision( )
{
  float d = dist( px, py, bx, by );
  //println( d );
  if ( d < collisionDistance)
  {
     fill( 0 );
     rect( 0, 0, width, height ); 
     bx = random( 50, width-50 );
     by = random( 50, height-50 );
     deltaBX = random( 3, 10 );
     deltaBY = random( 3, 10 );
     score = score + 1;
     if (score % 5 == 0 )
     {
         deltaPYChange = deltaPYChange + 0.3;
         deltaPXChange = deltaPXChange + 0.3;
     }
  }
}

void changeWrappingFigure( )
{
   // vertical stuff
   py = py + deltaPY;
   if ( py > height + 40 )
   {
      py = -40; 
      score = 0;
   } 
   if ( py <  -40 )
   {
      py = height + 40; 
      score = 0;
   } 
   
   
   
   // horizontal stuff
     px = px + deltaPX;
   if ( px > width + 40 )
   {
      px = -40; 
      score = 0;
   } 
   
     if ( px <  -40 )
   {
      px = width + 40; 
      score = 0;
   } 
}

void changeBouncingFigure( )
{
   // horizontal stuff
   bx = bx + deltaBX; 
   if( bx > width )  // too far right
   {    
     deltaBX = -deltaBX;
   }
    
   if ( bx < 0 )  // too far left
   {
     deltaBX = -deltaBX;
   }
   
   // vertical stuff
   by = by + deltaBY; 
   if( by > height )  // too far right
   {    
     deltaBY = -deltaBY;
   }
    
   if ( by < 0 )  // too far left
   {
     deltaBY = -deltaBY;
   }
   
   
}

void drawWrappingFigure( )
{
   fill( 0, 0, 200 );

   ellipse( px, py, 40, 40 );
   image ( p, px, py, 30, 30 );  
}

void drawBouncingFigure( )
{
  fill( 200, 0, 0 );  
  ellipse( bx, by, 33, 22 );
}  

void prepareScreen( )
{
  fill( 200, 200, 0, 30 );  
  rect(0, 0, width, height);
  fill( 0 );
  text( "Score: " + score, width/2, 50 );
  text( "Time: " + millis( )/1000, width/2, height-50 );
 
}



