signature LOOP =
sig
  type action = DBMinML.exp -> unit

  (* ... with its type *)
  val showType  : action

  (* apply an action to a completely evaluated expression *)
  val eval      : action -> action

  (* ... on a file *)
  val loopFile  : string -> action -> unit
end

structure Loop :> LOOP =
struct

  type action = DBMinML.exp -> unit

  fun typing e =
          (case Typing.typeOpt e
             of SOME t => " : " ^ DBPrint.typToString t
              | NONE => " has no type.")

  (* A few actions *)

  fun showType e =
      List.app print [DBPrint.expToString e, typing e, "\n"]

  fun eval action e = action (Eval.eval (#2(Typing.typecheck e)))

  (* Running the actions on an interactive loop or a file *)

  fun loopFile name action =
         Stream.app action
         ((Translate.translate o Parse.parse o Lexer.lex) 
              (Input.readfile name))

end
