#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

/*
   Jernej Barbic
   15-213, Section F, Spring 2006

   This code is a modified version of the code of:
   15-213, Section A, Fall 2004, Craig Soules.
   (changes mostly stylistic, more printouts, etc.)

*/

/***************************************************************
*  A simple SERVER: prints out the text received from the client
*  When client closes the connection, the server exits.
****************************************************************/

int main(int argc, char *argv[])
{
    int listeningFD, connectedFD, optval, error, port, clientLen;
    int retVal = 0;
    unsigned char buf[4096];
    struct sockaddr_in serverSocket, clientSocket;

    if (argc > 1)
    {
      printf("A simple server: it prints out the text received from client. Run without any arguments to start.\n");
      printf("Note: this is NOT the echo server.\n");
      return 1;
    }

    /* choose a port number > 1024 */
    port = 5556;

    printf("Creating TCP/IP socket ...\n");

    /* create a TCP socket */
    listeningFD = socket(AF_INET, SOCK_STREAM, 0);
    if(listeningFD < 0)
    {
        printf("Unable to create a TCP socket (%d)\n", errno);
        return -1;
    }

    printf("Listening file descriptor is %d\n",listeningFD);

    /* eliminates the "Address already in use" error from bind */
    optval = 1;
    error = setsockopt(listeningFD, SOL_SOCKET, SO_REUSEADDR,
                       (const void *)&optval, sizeof(int));
    if(error < 0)
    {
        printf("Unable to set socket options (%d)\n", errno);
        close(listeningFD);
        return error;
    }

    printf("Binding socket to port %d ...\n",port);

    /* bind the socket to a given port */
    memset(&serverSocket, 0, sizeof(serverSocket));
    serverSocket.sin_family = AF_INET;
    serverSocket.sin_addr.s_addr = htonl(INADDR_ANY);
    serverSocket.sin_port = htons((unsigned short)port);
    error = bind(listeningFD, (struct sockaddr*)&serverSocket, sizeof(serverSocket));
    if(error < 0)
    {
        printf("Unable to bind to port %d (%d)\n", port, errno);
        close(listeningFD);
        return error;
    }

    printf("Listening for a connection on port %d ...\n",port);

    /* listen for a connection */
    error = listen(listeningFD, 128); // this call exits immediately
    if(error < 0)
    {
        printf("Unable to listen on socket (%d)\n", errno);
        close(listeningFD);
        return error;
    }

    /* block until an incoming connection received */
    clientLen = sizeof(clientSocket);
    connectedFD = accept(listeningFD, (struct sockaddr *)&clientSocket, &clientLen); // returns a connected descriptor
    if(connectedFD < 0)
    {
        printf("Error accepting connection on socket (%d)\n", errno);
        error = -1;
        close(listeningFD);
        return error;
    }

    // clientAddr now contains the IP and port of the client that just connected
    printf("Accepted incoming connection. Connected file descriptor is %d .\n", connectedFD);

    printf("Client IP address is: %s\n",inet_ntoa(clientSocket.sin_addr));
    printf("Client port is: %d\n",clientSocket.sin_port);

    /* keep reading text from client until the socket is closed */
    while((error = read(connectedFD, buf, 4096)) > 0)
    {
        buf[error] = 0; /* NULL-terminate the buffer */
        printf("%s", buf);
    }

    if(error < 0)
    {
        printf("Error reading data from socket (%d)\n", errno);
    }

    printf("EOF received. Closing socket.\n");

    /* close the sockets and exit */
    close(connectedFD);

    close(listeningFD);
    return 0;
}
