#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>

/*
   Jernej Barbic
   15-213, Section F, Spring 2006

   This code is a modified version of the code of:
   15-213, Section A, Fall 2004, Craig Soules.
   (changes mostly stylistic, more printouts, etc.)

*/

/*****************************************************************
* A simple CLIENT: sends text to server, which then prints it out.
* When client closes the connection, the server exits.
******************************************************************/

int main(int argc, char *argv[])
{
    int fd, port, error;
    char *hostname, buf[4096];
    struct in_addr serverAddr;
    struct sockaddr_in serverSocket;
    struct hostent* serverDNSEntry;

    if (argc < 3)
    {
      printf("A simple client: sends text to server, which then prints it out.\n");
      printf("Note: this is NOT the echo client.\n");
      printf("Usage: %s <server name> <port>\n",argv[0]);
      return 1;
    }

    /* read the hostname and port from the command line */
    hostname = argv[1];
    port = atol(argv[2]);

    printf("Creating a TCP/IP socket...\n");

    /* create a TCP/IP socket */
    fd = socket(AF_INET, SOCK_STREAM, 0);
    if(fd < 0)
    {
        printf("Unable to create a TCP socket (%d)\n", errno);
        return -1;
    }

    printf("Socket file descriptor is %d .\n",fd);

    printf("Resolving the server IP address of %s using DNS...\n",hostname);

    /* get the server's IP address using gethostbyname() */
    serverDNSEntry = gethostbyname(hostname);
    if(serverDNSEntry == NULL)
    {
        printf("Unable to resolve %s (%d)\n", hostname, errno);
        error = -1;
        close(fd);
        return error;
    }
    serverAddr = *(struct in_addr*) serverDNSEntry->h_addr_list[0];
    printf("The server IP address is: %s\n", inet_ntoa(serverAddr));

    // fill-in the socket data structure
    memset(&serverSocket, 0, sizeof(serverSocket)); // reset to zero
    serverSocket.sin_family = AF_INET;
    serverSocket.sin_addr = serverAddr; // address returned by DNS is already in the network order
    serverSocket.sin_port = htons((unsigned short)port);

    printf("Connecting to server...\n");

    /* connect to the server machine */
    error = connect(fd, (struct sockaddr*)&serverSocket, sizeof(struct sockaddr_in));
    if(error < 0)
    {
        printf("Unable to connect to server (%d)\n", errno);
        close(fd);
        return error;
    }

    printf("Connection established. Connected file descriptor is %d.\n",fd);
    printf("Type any text and it will be sent to the server.\n");

    /* keep reading text lines from the keyboard and writing them to server */
    while(fgets(buf, 4096, stdin) != NULL)
    {
        error = write(fd, buf, strlen(buf));
        if(error < 0)
        {
            printf("Error on write to server (%d)\n", errno);
            close(fd);
            return error;
        }
    }

    printf("EOF received on stdin. Closing connection...\n");

    close(fd);
    return 0;
}
