/***************************************************************************
                          zephyrmsg.h  -  description
                             -------------------
    begin                : Wed Feb 26 2003
    copyright            : (C) 2003 by Chris Colohan
    email                : colohan+@cs.cmu.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef ZEPHYRMSG_H
#define ZEPHYRMSG_H

#include <qstring.h>
#define BOOST_NO_EXCEPTIONS
#include <boost/shared_ptr.hpp>

/**
  *@author Chris Colohan
  */

class ZephyrMsg {
    QString sender_;
    QString signature_;
    QString instance_;
    QString time_;
    long    time_secs_;
    bool    auth_;
    bool    personal_;
    QString message_;
    bool    fake_;
    bool    notified_;

public: 
    ZephyrMsg(QString sender,
	      QString signature,
	      QString instance,
	      QString time,
	      long    time_secs_,
	      bool    auth,
	      bool    personal,
	      QString message,
	      bool    fake = false);
    ~ZephyrMsg();

    QString sender() { return sender_; }
    QString signature() { return signature_; }
    QString instance() { return instance_; }
    QString time() { return time_; }
    long    time_secs() { return time_secs_; }
    bool    auth() { return auth_; }
    bool    personal() { return personal_; }
    QString message() { return message_; }
    bool    fake() { return fake_; }
    bool    notified() { return notified_; }
    void setNotified() { notified_ = true; }
};

typedef boost::shared_ptr<ZephyrMsg> ZephyrMsgPtr;

#endif
