/***************************************************************************
                          uitab.h  -  description
                             -------------------
    begin                : Wed Apr 2 2003
    copyright            : (C) 2003 by Chris Colohan
    email                : colohan+@cs.cmu.edu
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef UITAB_H
#define UITAB_H

#include <klineedit.h>
#include <qcheckbox.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qsplitter.h>
#include <qstringlist.h>
#include <qtabwidget.h>
#include <qwidget.h>
#include <list>
#include "recvpage.h"
#include "zephtextedit.h"
#include "zephyrmsg.h"
#include "filter.h"

using namespace std;


/**
 *@author Chris Colohan
 */

class UiTab : public QWidget  {
    Q_OBJECT
public: 
    UiTab(QString name,
	  Kzephyr *kzephyr,
	  QTabWidget *parent);
    ~UiTab();

    // Called whenever a zephyr is received:
    void gotZephyr(ZephyrMsgPtr msg);

    void editInstanceFilters();
    void remove();

    QString name() { return name_; }

    void saveOptions();

    void focusOnInstance(QString instance);
    void filterOutInstance(QString instance);

    void clearZephyrs();

    void addFilter(Filter filt);
    void setBeepOnNew(bool b) { beepOnNewZephyr_ = b; }
    void frontOnNew(bool f) { frontOnNewZephyr_ = f; }
    void setPersonalChecked(bool pc) { personalCheck->setChecked(pc); }


    RecvPage* rcvPage;
    QSplitter* splitter;
    KLineEdit* toEdit;
    ZephTextEdit* zephyrEdit;
    QPushButton* sendButton;
    QCheckBox* personalCheck;

private:
    QString name_;
    Kzephyr *kzephyr_;
    QTabWidget *parent_;
    bool removed_;

    bool instanceFiltersExclusive_;
    list<Filter> filterList_;

    bool beepOnNewZephyr_;
    bool frontOnNewZephyr_;

    list<ZephyrMsgPtr> zephyrs_;

    void appendZephyr(ZephyrMsgPtr msg);
    QString toHtml(ZephyrMsgPtr msg);
    QString makesafe(QString message);
    QString munge(ZephyrMsgPtr msg);
    bool showZephyr(ZephyrMsgPtr msg);
    void repopulate();
    void refilter();

private slots:
    void linkClicked(const QString &link);
};

#endif
