/***************************************************************************
                          tzc.h  -  description
                             -------------------
    begin                : Mon Sep 30 2002
    copyright            : (C) 2002 by Chris Colohan
    email                : colohan+@cs.cmu.edu
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TZC_H
#define TZC_H

#include <qthread.h>
#include <qstring.h>
#include <kconfig.h>

class Kzephyr;

/**
 *@author Chris Colohan
 */

class Tzc : public QThread  {
public: 
    Tzc(Kzephyr *kzephyr,
	KConfig *config);
    ~Tzc();

    // Send the given zephyr.  The recipient list and instance list
    // must be the same length -- public zephyrs do not specify a
    // recipient, and private zephyrs are usually on instance
    // "PERSONAL".
    void sendZephyr(QStringList recipients,
		    QStringList instances,
		    QString message);

    QString zsig;
    QString userid;
    QString tzc_command;

protected:
    void run();

private:
    Kzephyr *kzephyr_;
    KConfig *config_;

    int tzc_pid_;
    int to_tzc_[2];
    int from_tzc_[2];
    char input_buff_[1];
    QString input_line_;
    QString tzc_command_;
    bool exiting_;

    void start_tzc();
    void process_line();
    void readOptions();
    void saveOptions();
    void writeZephyr(QString message);
    QString armourZephyr(QString message);
    QString msg2HTML(QString message);
};

#endif
