/***************************************************************************
                          tabsettingsdialog.cpp  -  description
                             -------------------
    begin                : Sun Apr 6 2003
    copyright            : (C) 2003 by Chris Colohan
    email                : colohan+@cs.cmu.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// debugging:
#include <iostream>
using namespace std;

#include <klocale.h>
#include <qhbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qvbox.h>
#include <qvgroupbox.h>
#include <qwhatsthis.h>
#include "tabsettingsdialog.h"

TabSettingsDialog::TabSettingsDialog(list<Filter> filterList,
				     QWidget* parent,
				     const char* name,
				     bool modal,
				     WFlags fl) :
    QDialog(parent, name, modal, fl)
{
    if(name == NULL) {
	setCaption( tr2i18n( "Tab Settings" ) );
    }

    QVBoxLayout *VLayout1 = new QVBoxLayout(this, 5, 5);
    QVBox *vb1 = new QVBox(this);
    VLayout1->addWidget(vb1);
    
    QHBox *hb1 = new QHBox(vb1);
    QLabel *lab = new QLabel(hb1);
    lab->setText(tr2i18n("Tab Name:"));
    tabName = new KLineEdit(hb1);

    beepNew = new QCheckBox(vb1);
    beepNew->setText(tr2i18n("Beep when new zephyrs arrive"));

    frontNew = new QCheckBox(vb1);
    frontNew->setText(tr2i18n("Bring to front when new zephyrs arrive"));

   
    QVGroupBox *vgb = new QVGroupBox(QString("Instance Filters"), vb1);

    table_ = new QTable(0, 3, vgb);
    table_->horizontalHeader()->setLabel(0, tr2i18n("If..."));
    table_->horizontalHeader()->setLabel(1, tr2i18n("matches RegExp..."));
    table_->horizontalHeader()->setLabel(2, tr2i18n("then..."));
    table_->setRowMovingEnabled(true);
    table_->verticalHeader()->setResizeEnabled(false);

    for(list<Filter>::iterator i = filterList.begin();
	i != filterList.end(); i++) {
	setRow(addRow(), (*i));
    }

    QHBox *hb2 = new QHBox(vgb);
    QPushButton *add = new QPushButton(hb2);
    add->setText(tr2i18n("Add"));
    QPushButton *remove = new QPushButton(hb2);
    remove->setText(tr2i18n("Remove"));

    inclusive = new QComboBox(FALSE, vgb);
    inclusive->clear();
    inclusive->insertItem(tr2i18n("Discard zephyrs not matched by filters"));
    inclusive->insertItem(tr2i18n("Show all other zephyrs"));

    QPushButton *okButton = new QPushButton(vb1);
    okButton->setText(tr2i18n("&Ok"));

    connect(table_, SIGNAL(valueChanged(int, int)), this,
	    SLOT(valueChanged(int, int)));
    connect(add, SIGNAL(clicked()), this, SLOT(addRow()));
    connect(remove, SIGNAL(clicked()), this, SLOT(delRow()));
    connect(okButton, SIGNAL(clicked()), this, SLOT(accept()));

    QWhatsThis::add(tabName,
		    i18n("<qt>Give this tab a nice name so you can remember "
			 "what it is for.</qt>"));
    QWhatsThis::add(beepNew,
		    i18n("<qt>Don't you hate it how your office mate's "
			 "computer beeps whenever they get a message?  Well, "
			 "now you can get your revenge by making your "
			 "computer beep too!  Make sure you turn the volume "
			 "up really loud.</qt>"));
    QWhatsThis::add(frontNew,
		    i18n("<qt>If you check this then whenever a new message "
			 "arrives in this tab kzephyr will come to the front "
			 "and interrupt whatever you were doing.  If you "
			 "don't check this then the tab name will just get "
			 "a star next to it when a new message "
			 "arrives.</qt>"));
    QWhatsThis::add(table_,
		    i18n("<qt>Incoming zephyrs are first compared against "
			 "the first filter, and if it matches then the "
			 "specified action is applied.  If it doesn't match, "
			 "then the second filter is tried, and so on.  If no "
			 "filter matches then the default rule at the bottom "
			 "is used.  To change the order of the filters hold "
			 "down the control key and drag the row by the "
			 "number on the left.</qt>"));
    QWhatsThis::add(add,
		    i18n("<qt>Adds a new empty filter to the bottom of the "
			 "list.  To change the order of the filters hold "
			 "down the control key and drag the row by the "
			 "number on the left.</qt>"));
    QWhatsThis::add(remove,
		    i18n("<qt>Removes the last filter from the bottom of the "
			 "list.  To change the order of the filters hold "
			 "down the control key and drag the row by the "
			 "number on the left.</qt>"));
    QWhatsThis::add(inclusive,
		    i18n("<qt>This action is applied to zephyrs which are "
			 "not matched by the filters in the above "
			 "table.</qt>"));
    QWhatsThis::add(okButton,
		    i18n("<qt>Click here to accept changes, or close this "
			 "window using the \"X\" to throw away any "
			 "changes.</qt>"));
}

TabSettingsDialog::~TabSettingsDialog()
{
}

int
TabSettingsDialog::addRow()
{
    int pos = table_->numRows();
    table_->insertRows(pos);
    
    QStringList typeChoices;
    typeChoices += "sender";
    typeChoices += "instance";
    typeChoices += "contents";
    typeChoices += "auth";
    typeChoices += "personal";
    table_->setItem(pos, 0, new QComboTableItem(table_, typeChoices, false));

    table_->setItem(pos, 1, new QTableItem(table_, QTableItem::OnTyping, ""));

    QStringList actionChoices;
    actionChoices += "don't display";
    actionChoices += "display";
    table_->setItem(pos, 2, new QComboTableItem(table_, actionChoices, false));

    return pos;
}

void
TabSettingsDialog::delRow()
{
    table_->removeRow(table_->numRows() - 1);
}

void
TabSettingsDialog::setRow(int row,
			  Filter filter)
{
    ((QComboTableItem *)table_->item(row, 0))->
	setCurrentItem((int)filter.type());

    valueChanged(row, 0);

    if(filter.isCond()) {
	((QComboTableItem *)table_->item(row, 1))->
	    setCurrentItem((int)filter.cond());

    } else {
	table_->item(row, 1)->setText(filter.re().pattern());
    }

    ((QComboTableItem *)table_->item(row, 2))->
	setCurrentItem((int)filter.accept());
}

void
TabSettingsDialog::valueChanged(int row,
				int col)
{
    if(col == 0) {
	QComboTableItem *cti = (QComboTableItem *)table_->item(row, 0);

	QTableItem *ti = (QTableItem *)table_->item(row, 1);
	bool isComboTableItem = ti->rtti() == 1;

	// Magic #: > 2 means it is a boolean choice (auth or
	// personal) instead of something that matches a regexp:
	if(cti->currentItem() > 2) {
	    if(!isComboTableItem) {
		QStringList actionChoices;
		actionChoices += "is false";
		actionChoices += "is true";
		table_->setItem(row, 1,
				new QComboTableItem(table_, actionChoices,
						    false));
	    }
	} else {
	    if(isComboTableItem) {
		table_->setItem(row, 1,
				new QTableItem(table_,
					       QTableItem::OnTyping, ""));
	    }
	}
    }
}

void
TabSettingsDialog::getFilters(list<Filter> *filterList)
{
    filterList->clear();
    for(int i = 0; i < table_->numRows(); i++) {
	Filter::Type type =
	    (Filter::Type)((QComboTableItem *)table_->item(i, 0))->
	    currentItem();
	bool accept = ((QComboTableItem *)table_->item(i, 2))->currentItem();
	
	if(type > 2) {
	    bool cond = ((QComboTableItem *)table_->item(i, 1))->currentItem();

	    Filter filt(type, accept, cond);
	    filterList->push_back(filt);

	} else {
	    Filter filt(type, accept,
			QRegExp(table_->item(i, 1)->text()));
	    filterList->push_back(filt);
	}
    }
}
