/***************************************************************************
                          recvpage.cpp  -  description
                             -------------------
    begin                : Sat Dec 21 2002
    copyright            : (C) 2002 by Chris Colohan
    email                : colohan+@cs.cmu.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <ktextbrowser.h>
#include <keditlistbox.h>
#include <klineedit.h>
#include <kmessagebox.h>
#include <qcheckbox.h>
#include <qregexp.h>
#include "recvpage.h"
#include "kzephyr.h"

RecvPage::RecvPage(QWidget *parent,
		   const char *name) :
    KTextBrowser(parent, name)
{
    //////////////////////////////////////////////////////////////////////////
    // START configuration borrowed from kopete:
    //
    // Copyright (c) 2001-2002 by Duncan Mac-Vicar Prett <duncan@kde.org>
    // Copyright (c) 2002      by Ryan Cumming           <bodnar42@phalynx.dhs.org>
    // Copyright (c) 2002      by Stefan Gehn            <sgehn@gmx.net>
    // Copyright (c) 2002      by Martijn Klingens       <klingens@kde.org>
    // 
    // Kopete    (c) 2001-2002 by the Kopete developers  <kopete-devel@kde.org>
    setHScrollBarMode(QTextEdit::AlwaysOff);
    setReadOnly(true);
    setWordWrap(QTextEdit::WidgetWidth);
    setWrapPolicy(QTextEdit::AtWhiteSpace);
    setTextFormat(Qt::RichText);

    QStyleSheetItem *_style;
    _style = new QStyleSheetItem ( styleSheet(), "table" );
    _style->setDisplayMode(QStyleSheetItem::DisplayBlock);
    _style->setMargin ( QStyleSheetItem::MarginAll, 0 );
    _style->setWhiteSpaceMode ( QStyleSheetItem::WhiteSpacePre );
    _style->setLineSpacing ( 0 );

    _style = new QStyleSheetItem ( styleSheet(), "tr" );
    _style->setDisplayMode(QStyleSheetItem::DisplayBlock);
    _style->setMargin ( QStyleSheetItem::MarginAll, 0 );
    _style->setWhiteSpaceMode ( QStyleSheetItem::WhiteSpacePre );
    _style->setLineSpacing ( 0 );

    _style = new QStyleSheetItem ( styleSheet(), "td" );
    _style->setDisplayMode(QStyleSheetItem::DisplayBlock);
    _style->setMargin ( QStyleSheetItem::MarginAll, 0 );
    _style->setWhiteSpaceMode ( QStyleSheetItem::WhiteSpacePre );
    _style->setLineSpacing ( 0 );

    _style = new QStyleSheetItem ( styleSheet(), "p" );
    _style->setDisplayMode(QStyleSheetItem::DisplayBlock);
    _style->setMargin ( QStyleSheetItem::MarginAll, 0 );
    _style->setWhiteSpaceMode ( QStyleSheetItem::WhiteSpacePre );
    _style->setLineSpacing ( 0 );

    // END configuration borrowed from kopete
    //////////////////////////////////////////////////////////////////////////

    setNotifyClick(true);
}

RecvPage::~RecvPage()
{
}

void
RecvPage::scroll(QKeyEvent *e)
{
    assert(e->key() == Qt::Key_PageUp ||
	   e->key() == Qt::Key_PageDown);

    keyPressEvent(e);
}
