/***************************************************************************
                          parsetree.cpp  -  description
                             -------------------
    begin                : Sun Sep 29 2002
    copyright            : (C) 2002 by Chris Colohan
    email                : colohan+@cs.cmu.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>
#include "parsetree.h"

ParseTree ParseTree::nullParseTree("");

ParseTree::ParseTree(QString source, bool do_parse) :
    numChildren_(0)
{
    if(do_parse) {
#ifdef DEBUG_PARSE
	printf("Parsing subset: \"%s\"\n", source.latin1());
#endif
	unsigned p = 0;
	while(p < source.length()) {
	    // Found start of subtree, scan until end of subtree:

#ifdef DEBUG_PARSE
	    printf("What is left: \"%s\"\n",
		   source.right(source.length()-p).latin1());
#endif

	    // Eat white space:
	    if(source[p].isSpace() ||
	       source[p] == '\001') {
		p++;
		continue;
	    }

	    // Skip comments
	    if(source[p] == ';') {
#ifdef DEBUG_PARSE
		printf("Skipping comment...\n");
#endif
		while(source[p] != '\n' &&
		      p < source.length()) {
		    p++;
		}
		continue;
	    }

	    unsigned end;
	    if(source[p] == '(') {
		p++;
		end = p;
		int nesting = 0;
		bool in_quote = false;
		bool escape_next = false;
		while(!(source[end] == ')' &&
			nesting == 0 &&
			!in_quote) &&
		      end < source.length()) {
		    if(!escape_next) {
			if(source[end] == '\\') {
			    escape_next = true;
			}
			if(!in_quote) {
			    if(source[end] == '(') {
				nesting++;
			    }
			    if(source[end] == ')') {
				nesting--;
			    }
			}
			if(source[end] == '"') {
			    in_quote = !in_quote;
			}
		    } else {
			escape_next = false;
		    }
		    end++;
		}
		do_parse = true;

	    } else {
		char end_char;
		if(source[p] == '"') {
		    end_char = '"';
		    p++;
		} else {
		    end_char = ' ';
		}					      
		do_parse = false;

#ifdef DEBUG_PARSE
		printf("source[p] = \"%c\", Looking for the end_char of '%c' in \"%s\"\n",
		       source[p].latin1(),
		       end_char,
		       source.right(source.length() - p).latin1());
#endif
		end = p;
		while(source[end] != end_char &&
		      end < source.length()) {
		    if(source[end] == '\\') end++;
		    end++;
		}
	    }
	    children_[numChildren_++] =
		new ParseTree(source.mid(p, end - p), do_parse);
	    p = end + 1;
	}
    } else {
#ifdef DEBUG_PARSE
	printf("Found end node: %s\n", source.latin1());
#endif
	contents_ = source;
    }
}

ParseTree::~ParseTree()
{
    if(children_) {
	for(int i = 0; i < numChildren_; i++) {
	    delete children_[i];
	}
    }
}


ParseTree *
ParseTree::child(int index)
{
    if(index < numChildren_) {
	return children_[index];
    } else {
	return &nullParseTree;
    }
}

ParseTree *
ParseTree::findNode(QString key)
{
    if(numChildren_ > 0 &&
       child(0)->contents().compare(key) == 0) {
	return this;
    } else {
	ParseTree *result = &nullParseTree;
	for(int i = 0; i < numChildren_; i++) {
	    result = child(i)->findNode(key);
	    if(result != &nullParseTree) {
		break;
	    }
	}
	return result;
    }
}

QString
ParseTree::dump()
{
    QString result;
    if(numChildren_ == 0) {
	result += "\"";
	result += contents_;
	result += "\" ";
    } else {
	for(int i = 0; i < numChildren_; i++) {
	    result += "( ";
	    result += children_[i]->dump();
	    result += ")";
	}
    }
    return result;
}

