/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Sat Sep 28 14:51:54 EDT 2002
    copyright            : (C) 2002 by Chris Colohan
    email                : colohan+@cs.cmu.edu
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>

#include "kzephyr.h"
#include "tzc.h"

static const char *description =
I18N_NOOP("Kzephyr:  A GUI front end to tzc, the trivial zephyr client");
	
	
static KCmdLineOptions options[] =
{
    { 0, 0, 0 }
};

int main(int argc, char *argv[])
{

    KAboutData aboutData( "kzephyr", I18N_NOOP("Kzephyr"),
			  VERSION, description, KAboutData::License_GPL,
			  "(c) 2002, Chris Colohan", 0, 0, "colohan+@cs.cmu.edu");
    aboutData.addAuthor("Chris Colohan",0, "colohan+@cs.cmu.edu");
    aboutData.addAuthor("Tom Murphy", "Icon design", 0, "http://tom7.org");
    KCmdLineArgs::init( argc, argv, &aboutData );
    KCmdLineArgs::addCmdLineOptions( options ); // Add our own options.

    KApplication a;
    Kzephyr *kzephyr = new Kzephyr(a.config());
    a.setMainWidget(kzephyr);

    // Tzc handles the tzc subprocess, which does the actual sending
    // and receiving of zephyrs:
    Tzc tzc(kzephyr, a.config());

    kzephyr->init(&tzc);

    // Start up the ui:
    kzephyr->show();  
    int rc = a.exec();
    return rc;
}
