#include <klocale.h>
#include <qlayout.h>
#include <qwhatsthis.h>
#include "kzephyrui.h"
#include "uitab.h"


/* 
 *  Constructs a KzephyrUI which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f'.
 */
KzephyrUI::KzephyrUI( QWidget* parent,  const char* name, WFlags fl )
    : QWidget( parent, name, fl )
{
    // Fill the whole frame:
    QVBoxLayout* VLayout1 = new QVBoxLayout(this);

    TabWidget = new QTabWidget(this);
    VLayout1->addWidget(TabWidget);

    connect(TabWidget, SIGNAL(currentChanged(QWidget*)), this,
	    SLOT(tabChanged(QWidget*)));

    QWhatsThis::add(TabWidget,
		    i18n("<qt>Your incoming zephyrs can be divided into "
			 "different Tabs.  See the above <b>Tabs</b> menu "
			 "for options to create, delete, and manipulate "
			 "tabs.</qt>"));
}

/*  
 *  Destroys the object and frees any allocated resources
 */
KzephyrUI::~KzephyrUI()
{
    // no need to delete child widgets, Qt does it all for us
}


void
KzephyrUI::tabChanged(QWidget *w)
{
    TabWidget->setTabLabel(w, ((UiTab *)w)->name());
}
