/***************************************************************************
                          kzephyr.h  -  description
                             -------------------
    begin                : Sat Sep 28 14:51:54 EDT 2002
    copyright            : (C) 2002 by Chris Colohan
    email                : colohan+@cs.cmu.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KZEPHYR_H
#define KZEPHYR_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapp.h>
#include <kmainwindow.h>

#include <iostream>
#include <list>
#include <set>
using namespace std;

#include "tzc.h"
#include "kzephyrui.h"
#include "uitab.h"
#include "instancefilterdialog.h"
#include "zephyrmsg.h"

class Kzephyr : public KMainWindow
{
    Q_OBJECT 

    KzephyrUI *ui_;
    QHBoxLayout *layout_;
    KConfig *config_;
    list<UiTab *> uiTabs_;
    KAction *removeTabAction_;
    ZephyrMsgPtr sentZephyr_;
    UiTab *sentZephyrTab_;

    UiTab *curPage() { return (UiTab *)ui_->TabWidget->currentPage(); }
    QString formatMessage(QString msg);

public:
    Kzephyr(KConfig *config,
	    QWidget* parent=0,
	    const char *name=0);
    ~Kzephyr();

    void init(Tzc *t) { tzc = t; }

    // We just got a zephyr!
    void recvZephyr(ZephyrMsgPtr msg);

    // Called after a zephyr has been transmitted:
    void zephyrSent(bool success);

    // A user is about to send us a zephyr using zwrite:
    void ping(QString user);

    KConfig *config() { return config_; }

    void saveOptions();

    QString makeTabNameUnique(QString name);
    
    // Global configuration:
    int history_size;
    bool show_sigs;
    bool show_faces;
    bool url_archive;

    set<QString> useridList;
    Tzc *tzc;

    UiTab *addTabInstance(QString instance);
    
 public slots:
    void sendZephyr();
    void clearZephyrs();
    void addTab();
    void removeTab();
    void editInstanceFilters();
    void preferences();
    void statusMsg(const QString &text);
    void keyPressEvent(QKeyEvent *e);
};

#endif
