/***************************************************************************
                          filter.h  -  description
                             -------------------
    begin                : Sun Apr 6 2003
    copyright            : (C) 2003 by Chris Colohan
    email                : colohan+@cs.cmu.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef FILTER_H
#define FILTER_H

#include <qregexp.h>
#include "zephyrmsg.h"

/**
  *@author Chris Colohan
  */

class Filter {
public:
    enum Type {
	SENDER,
	INSTANCE,
	MESSAGE,
	AUTH,
	PERSONAL
    };

    enum Status {
	REJECT,
	ACCEPT,
	DONTCARE
    };

private:
    Type type_;
    bool accept_;
    QRegExp re_;
    bool cond_;

public: 
    Filter(Type type, bool accept, QRegExp re) :
	type_(type),
	accept_(accept),
	re_(re) { assert(!isCond()); }
    Filter(Type type, bool accept, bool cond) :
	type_(type),
	accept_(accept),
	cond_(cond) { assert(isCond()); }
    Filter(QString type, QString accept, QString re);
    Filter(const Filter &f) :
	type_(f.type_),
	accept_(f.accept_),
	re_(f.re_),
	cond_(f.cond_) {}

    bool isCond() { return type_ == AUTH || type_ == PERSONAL; }
    Type type() { return type_; }
    bool accept() { return accept_; }
    QRegExp re() { assert(!isCond()); return re_; }
    bool cond() { assert(isCond()); return cond_; }
    
    QString typeStr();
    QString acceptStr();
    QString reStr();
    
    Status apply(ZephyrMsgPtr msg);
};

#endif
