/***************************************************************************
                          filter.cpp  -  description
                             -------------------
    begin                : Sun Apr 6 2003
    copyright            : (C) 2003 by Chris Colohan
    email                : colohan+@cs.cmu.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "filter.h"

Filter::Filter(QString type, QString accept, QString re)
{
    if(QString("SENDER").compare(type) == 0) {
	type_ = SENDER;
    } else if(QString("INSTANCE").compare(type) == 0) {
	type_ = INSTANCE;
    } else if(QString("MESSAGE").compare(type) == 0) {
	type_ = MESSAGE;
    } else if(QString("AUTH").compare(type) == 0) {
	type_ = AUTH;
    } else if(QString("PERSONAL").compare(type) == 0) {
	type_ = PERSONAL;
    } else {
	assert(0);
    }

    if(QString("ACCEPT").compare(accept) == 0) {
	accept_ = true;
    } else if(QString("REJECT").compare(accept) == 0) {
	accept_ = false;
    } else {
	assert(0);
    }

    if(isCond()) {
	if(re.compare("TRUE") == 0) {
	    cond_ = true;
	} else {
	    cond_ = false;
	}
    } else {
	re_ = QRegExp(re.mid(1, re.length() - 2));
    }
}

Filter::Status
Filter::apply(ZephyrMsgPtr msg)
{
    bool match = false;
    switch(type_) {
    case SENDER:
	match = re_.search(msg->sender()) != -1;
	break;
    case INSTANCE:
	match = re_.search(msg->instance()) != -1;
	break;
    case AUTH:
	match = msg->auth() == cond_;
	break;
    case PERSONAL:
	match = msg->personal() == cond_;
	break;
    case MESSAGE:
	match = re_.search(msg->message()) != -1;
	break;
    default:
	assert(0);
	break;
    }

    if(match) {
	return accept_ ? ACCEPT : REJECT;
    } else {
	return DONTCARE;
    }
}

QString
Filter::typeStr()
{
    switch(type_) {
    case SENDER:
	return QString("SENDER");
    case INSTANCE:
	return QString("INSTANCE");
    case MESSAGE:
	return QString("MESSAGE");
    case AUTH:
	return QString("AUTH");
    case PERSONAL:
	return QString("PERSONAL");
    default:
	assert(0);
    }
    return QString("????");
}

QString
Filter::acceptStr()
{
    if(accept_) {
	return QString("ACCEPT");
    } else {
	return QString("REJECT");
    }
}

QString
Filter::reStr()
{
    if(isCond()) {
	return cond_ ? QString("TRUE") : QString("FALSE");

    } else {
	return QString("\"") + re_.pattern() + QString("\"");
    }
}
