#include "collector.h"

int updateArchive( vector <measureInfo> *measures, 
	     long currentTime ,
	     long sampleRate,
	     struct tm *Time
	     )
{

  char 	tmp[NAMELENGTH],
  	day[5];


  struct stat status;
  string month, year;
  month.assign((const char*)NumToMonth(Time->tm_mon));

  if (month == "ERR") return -1;

  sprintf(tmp, "%d", (Time->tm_year + 1900) );
  year.assign(tmp);

  int i, j, k;
  string dataFile, tmpString, directory;
  char dataLine[500];
  char holder[500];
  string location;
  ifstream readFile;
  ofstream writeFile;

  vector <measureInfo>:: iterator measurep=(*measures).begin();
  for(i=0;i<(*measures).size(); i++)
  {
    directory= "archive/RAW/";
    directory = directory + (*measurep).alias
		+ "/" + year + "/" + month;

    dataFile= (*measurep).alias + year + month;
    sprintf(day,"%.2d.dat", Time->tm_mday );
    tmpString.assign(day);
    dataFile += tmpString;

    location = directory + "/" + dataFile;

    // cout << "location = " << location << endl;

    if( stat (location.c_str() , &status) != -1)
    {
      readFile.open(location.c_str(), ios::in);
      if(!readFile) return(-1);

      k=0;
      readFile.getline(holder, 4096, '\n');
      while(!readFile.eof())
      {
        strcpy(dataLine,holder);
	readFile.getline(holder, 4096, '\n');
	k++;
      }
      readFile.close();

      if(k>1)
      {
        writeFile.open(location.c_str(), ios::app);
        if(!writeFile) return(-1);

        long lastRecordTime;
        char lastValue[512];
        sscanf(dataLine, "%d %s", &lastRecordTime, &lastValue);
  
        lastRecordTime+=sampleRate;
        while(lastRecordTime < currentTime)
        {
          writeFile << lastRecordTime << " NA" << endl;
          lastRecordTime+=sampleRate;
        }
        writeFile.close();
      }
    }
    measurep++;
  }

  return(1);
}
