#include "readTopology.h"

#ifdef DEBUG_READ_TOPOLOGY

int main()
{
  char *topologyFile = "topology.txt";
  hostInfo host[5];

#else

int getTopology( char topologyFile[],
		hostInfo *host ,
		HOST_INDEX_MAP *hostIndex )
{

#endif /* DEBUG_READ_TOPOLOGY */


    ifstream top(topologyFile, ios::in);

    char line[500];
    char comments[500];
    LINE net[500];
    LINE file[500];
    KEYWORDMAP keyWordMap;

    bool rv;
    int i=0;
    while( !top.eof())
    {
      top >> line;

      // Skip the comments and put each real line into the 
      // file vector

      if(line[0]=='#') 
      {
	top.getline(comments, 4096, '\n');
	continue;
      }

      strcpy(file[i].line, line);

      // Go find the key words & put them into the keyword map
      // this way the location in the file vector is known

      if( strcmp(line,"[NODES]") == 0) {  
        int nodeStartLoc = i;
	keyWordMap.insert(KEYWORDMAP::value_type(i,"NODE"));
      }
      if( strcmp(line,"[NETWORKS]") == 0) {  
        int netStartLoc = i;
	keyWordMap.insert(KEYWORDMAP::value_type(i,"NETWORKS"));
      }
      i++;
    }
    top.close();

    int numFileLines = i;
#ifdef DEBUG_READ_TOPOLOGY
    for(i=0; i< numFileLines; i++)
    {
      cout << file[i].line << endl;
    }
#endif /* DEBUG_READ_TOPOLOGY */

    KEYWORDMAP :: iterator  keyp = keyWordMap.begin();
    KEYWORDMAP :: iterator  tempKey  = keyp;
    int j;
    int rangeStop;
    string tmpstr;
    int numHosts = -1;

    cout << "BEFORE LOOP" << endl;
    while( keyp != keyWordMap.end())
    {
	cout << (*keyp).first << "  "  << (*keyp).second << endl;
	tempKey++;
	rangeStop = (*tempKey).first;
	if(tempKey == keyWordMap.end() ) 
		rangeStop = numFileLines;

	if( (*keyp).second =="NODE")
	{
	  j=0; // j is the index for the hosts
	  for(i=(*keyp).first; i< rangeStop; i++)
	  {
	    if(strcmp(file[i].line, "Name") == 0)
	    {
	      i=i+2;
	      strcpy(host[j].hostName, file[i].line);
	      tmpstr.assign(file[i].line);
	      hostIndex->insert(HOST_INDEX_MAP:: value_type(tmpstr, j));
	      j++;
	    }
	    numHosts = j;
	  }
	}
	else
	if ( (*keyp).second == "NETWORKS")
	{
	  j=0;
	  for(i=(*keyp).first; i< rangeStop; i++)
	  {
	    if(strcmp(file[i].line, "Name") == 0)
	    {
	      i=i+2;
	      strcpy(net[j].line, file[i].line);
         cout << net[j].line << endl;
	      j++;
	    }
	  }
	}
	else
	{
	  cout << "ERROR " << endl;
	  return (-1);
	}
	keyp++;
    }
    cout << "READTOP" << endl;
    return(numHosts);  // the number of hosts in the toplogyfile
}
