#include "readConfig.h"

#ifdef DEBUG_READ_CONFIG

int main()
{
  char *configFile = "config.txt";

#else

int getConfiguration(	char configFile[],
			vector <measureInfo> *measures,
			hostInfo *host, 
			HOST_INDEX_MAP *hostIndex,
			struct tm holidays[] ,
			measureCondition *currentContions)
{

#endif /* DEBUG_READ_CONFIG */

    FILE *fp;
    ifstream config(configFile, ios::in);

    char line[500];
    char comments[500];
    LINE net[500];
    string file[5000];
    KEYWORDMAP keyWordMap;

    bool rv;
    int i=0;
    
    while( !config.eof())
    {
      config >> line;

      // Skip the comments and put each real line into the 
      // file vector


      if(line[0]=='#') 
      {
	config.getline(comments, 4096, '\n');
	continue;
      }

      file[i].assign(line);

      // Go find the key words & put them into the keyword map
      // this way the location in the file vector is known

      if( strcmp(line,"[HOLIDAYS]") == 0) {  
        int nodeStartLoc = i;
	keyWordMap.insert(KEYWORDMAP::value_type(i,"HOLIDAYS"));
      }
      if( strcmp(line,"[END_HOLIDAYS]") == 0) {  
        int nodeStartLoc = i;
	keyWordMap.insert(KEYWORDMAP::value_type(i,"HOLIDAYS END"));
      }
      if( strcmp(line,"[MEASUREMENTS]") == 0) {  
        int netStartLoc = i;
	keyWordMap.insert(KEYWORDMAP::value_type(i,"MEASUREMENTS"));
      }
      if( strcmp(line,"[END_MEASUREMENTS]") == 0) {  
        int netStartLoc = i;
	keyWordMap.insert(KEYWORDMAP::value_type(i,"MEASUREMENTS END"));
      }
      if( strcmp(line,"CONDITION") == 0) {  
        int netStartLoc = i;
	keyWordMap.insert(KEYWORDMAP::value_type(i,"CONDITION"));
      }
      i++;
    }
    config.close();

    int numFileLines = i;
    /*
    for(i=0; i< numFileLines; i++)
    {
      cout << file[i] << endl;
    }
    */

    KEYWORDMAP :: iterator  keyp = keyWordMap.begin();
    KEYWORDMAP :: iterator  tempKey  = keyp;

    int seg; 
    int rangeStop;
    const char *cmdline;
    int rangeStart; 
    int conditionFlag = 0;
    while( keyp != keyWordMap.end())
    {
	// cout << (*keyp).first << "  "  << (*keyp).second << endl;
	tempKey++;
	rangeStop = (*tempKey).first;
	if(tempKey == keyWordMap.end() ) 
		rangeStop = numFileLines;

	if( (*keyp).second =="HOLIDAYS")
	{
          int month, day, year;
	  int j =1;  // loop counter for the holiday array.
			// in [0] I store the total holiday count
			// in holiday[0].tm_year
          long now;
          struct tm *tmPtr ;
	  rangeStart = (*keyp).first +1;
	  keyp++;
	  rangeStop = (*keyp).first;
	  for(i=rangeStart; i< rangeStop; i++)
	  {
	    cmdline = file[i].c_str();
	    sscanf(cmdline, "%d/%d/%d", &month, &day, &year);

	    if((month < 1)|| (month > 12)) return (-1);
	    if((day < 1) || (day > 31)) return(-1);
	    if(year < 1) return(-1);
	    /*
	    // is this OK for the # days in this month?
	    */
	    if((month % 2) ==0)
	    {
	      if(day > 30) return(-1);
	    }

	    /*
	    // check for leap year
	    */
	    if(( year % 4) !=0)
	    {
	      if( (month==2) && (day>28) ) return(-1);
	    }
	    else
	      if( (month==2) && (day>29) ) return(-1);

	    tmPtr = localtime(&now);
	    holidays[j] = *tmPtr;
	    holidays[j].tm_year = year - 1900;
	    holidays[j].tm_mon = month - 1 ;
	    holidays[j].tm_mday = day ;
	    j++;

	    month = day = year = -1;
	  }
	  holidays[0].tm_year = j;
	}
	else
	if ( (*keyp).second == "MEASUREMENTS")
	{
          HOST_INDEX_MAP parameterID;
	  HOST_INDEX_MAP :: iterator  listp;
	  rangeStart = (*keyp).first +1;
	  keyp++;
	  rangeStop = (*keyp).first;
	  HOST_INDEX_MAP :: iterator index;
	  string cmd, param;
	  measureInfo cmdStuff;
	  for(i=rangeStart; i< rangeStop; i++)
	  {
	    cmd = file[i];
	    if(file[i] == "BW")
	    { 
	      /*
	      // command format is... 
              //    BW <alias> <machine source> < port > 
	      // a check is done on the source.  we assume the 
	      // IP port destination is correct.
	      */
	      cmdStuff.measureType = BW;
	      i++;
	      param = file[i];
	      cout << "FILE:  " << file[i] << endl;
	      listp= parameterID.find(file[i]); // this ID been used?
	      if(listp != parameterID.end() ) return (-1);
	      parameterID.insert(HOST_INDEX_MAP::
			value_type(file[i],0)); 

	      cmdStuff.alias = file[i];
	      i++;
	      cmdStuff.hostName = file[i];
	      i++; 
	      cmdStuff.port = atoi(file[i].c_str());
	      (*measures).push_back(cmdStuff);
   cout << "***** " << i << " *****" << endl;

	    }
	    else
	    if(file[i] == "DELAY")
	    {
	      /*
	      // command format is...
   //    DELAY <parameter id> <machine source> < IP port destination>
	      // a check is done on the source.  we assume the 
	      // IP port destination is correct.
	      */
	      i++;
	      param = file[i];

	      listp= parameterID.find(file[i]); // this ID been used?
	      if(listp != parameterID.end() ) return (-1);
	      parameterID.insert(HOST_INDEX_MAP::
			value_type(file[i],0)); 

	      i++;
	      index = hostIndex->find(file[i]);  // find source
              if(index == hostIndex->end()) return (-1);
	      i++;  			  
	      cmd = cmd + " " + file[i]; 	// command to remote machine
	      host[(*index).second].remoteCMD.push_back(cmd);
	      host[(*index).second].paramID.push_back(param);
	      host[(*index).second].remoteDATA.push_back("0.0");

	      cout << "------CMD  " << cmd << endl;
	      //host[ (*index).second ].measure.insert(MEASURE_MAP::value_type(cmd, 0.0));
	    }
	    else
	    if(file[i] == "LOAD")
	    {
	      /*
	  // command format is...LOAD <parameter id> <machine source> 
	      */
	      i++;
	      param = file[i];
	      listp= parameterID.find(file[i]); // this ID been used?
	      if(listp != parameterID.end() ) return (-1);
	      parameterID.insert(HOST_INDEX_MAP::
			value_type(file[i],0)); 

	      i++;
	      index = hostIndex->find(file[i]);  // find source
              if(index == hostIndex->end()) return (-1);
	      cmd = cmd + " "+ file[i]; 	// command to remote machine
	      host[(*index).second].remoteCMD.push_back(cmd);
	      host[(*index).second].paramID.push_back(param);
	      host[(*index).second].remoteDATA.push_back("0.0");

	      cout << "------CMD  " << cmd << endl;
	      //host[ (*index).second ].measure.insert(MEASURE_MAP::value_type(cmd, 0.0));
	    }
	    else
	      return (-1);
	  }
	}
	else
	if ( (*keyp).second == "CONDITION")
	{
	  conditionFlag = 1;
	  measureCondition currentConditions;
	  /*
	  // command format is....
      // CONDITION = < WEEKEND | WEEKDAY | EMERGENCY >


	  */
	  i = (*keyp).first+ 1;		

	  // is the condition the only command 
	  // in the config file? if not, then check what's 
	  // directly behind the CONDITION key word to make
	  // sure it's not garbage
	  if( i != 0)
	  {
	    if(( file[i-2]!="[END_MEASUREMENTS]") &&
	       ( file[i-2]!="[END_HOLIDAYS]"))       return(-1); 
          }

	  // check current location for  "=" sign
	  if(file[i] != "=") return (-1);

	  i++;				// get condition value

	  if(file[i] == "COMMON") currentConditions = COMMON;
	  else
	  if (file[i] == "EMERGENCY") currentConditions = EMERGENCY;
	  else
	    return(-1);
	  
	  i++;
	  if(file[i] != "") return(-1); // this had better be the last thing
					// in this file
	}
	keyp++;
    }

    if(conditionFlag == 0) return (-1);

    cout << "CONFIG" << endl;
    return(1);  // current conditions being measured
}
