#include "collector.h"

#ifdef CREATE_ARCHIVE 

int main()
{
  hostdata debugHD; 
  struct tm debugTime;

  strcpy(debugHD.entityName, "amaranth1.ices.cmu.edu");
  strcpy(debugHD.typeOfMeasure, "host");
  strcpy(debugHD.measure, "I just measured the day");

  debugTime.tm_year = 98;
  debugTime.tm_mon = 9;
  debugTime.tm_mday = 13;
  debugTime.tm_hour = 11;
  debugTime.tm_min = 12;
  debugTime.tm_sec = 13;

  struct tm *Time; 
  hostdata *HD; 

  HD = &debugHD;
  Time = &debugTime;
#else

int createArchive(int numHosts,
                  vector <measureInfo> *measures, 
	          struct tm *Time)
{

#endif /* CREATE_ARCHIVE */

  FILE *fp;
  int	Weekend=0, Weekday=1, Emergency=0;
  struct stat	status;
  char 	*month,
  	year[NAMELENGTH],
  	*tmp,
  	DataFileName[400],
  	Mk_DirectoryName_Cmd[NAMELENGTH],
  	DirectoryName[NAMELENGTH];


  /*
   *  Create the correct file name and directory
   *
   */
  sprintf(year,"%d", (Time->tm_year + 1900));

  month = (char *)malloc( 3 * sizeof(char) + 1);
  month = (char*)NumToMonth(Time->tm_mon);

  if (strcmp(month, "ERR") == 0)  return -1;

  // create the archive directory if necessary
  sprintf(DataFileName, "archive"); 
  sprintf(Mk_DirectoryName_Cmd, "mkdir archive");
  if( stat (DataFileName , &status) == -1)
    system(Mk_DirectoryName_Cmd);

  // Create <RAW> sub-directory if necessary
  sprintf(DataFileName, "archive/RAW");
  sprintf(Mk_DirectoryName_Cmd, "mkdir archive/RAW");
  if( stat (DataFileName , &status) == -1)
    system(Mk_DirectoryName_Cmd);

  int i, j;
  vector <measureInfo>:: iterator measurep = (*measures).begin();
  for(i=0;i< (*measures).size();i++)
  {
    // Create <parameter> sub-directory if necessary
    sprintf(DataFileName,"archive/RAW/%s", 
	      (*measurep).alias.c_str() );
    sprintf(Mk_DirectoryName_Cmd,"mkdir archive/RAW/%s", 
	      (*measurep).alias.c_str() );
    if( stat (DataFileName , &status) == -1)
      system(Mk_DirectoryName_Cmd);
  
    // Create <year> sub-directory if necessary
    sprintf(DataFileName,"archive/RAW/%s/%s", 
	      (*measurep).alias.c_str(), year );
    sprintf(Mk_DirectoryName_Cmd,"mkdir archive/RAW/%s/%s", 
	      (*measurep).alias.c_str(), year );
    if( stat (DataFileName , &status) == -1)
      system(Mk_DirectoryName_Cmd);
  
    // Create <month> sub-directory if necessary
    sprintf(DataFileName,"archive/RAW/%s/%s/%s",
	      (*measurep).alias.c_str(), year, month);
    sprintf(Mk_DirectoryName_Cmd,"mkdir archive/RAW/%s/%s/%s", 
	      (*measurep).alias.c_str(), year, month);
    if( stat (DataFileName , &status) == -1)
      system(Mk_DirectoryName_Cmd);
  
    cout << "Final file directory  " << DataFileName << endl;
    measurep++;
    
  }
  return(1);
}
