#ifndef _COLLECTOR_H
#define	_COLLECTOR_H

#include <rpc/rpc.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <errno.h>
#include <sys/stat.h>
#include <signal.h>
#include <unistd.h>
#include <sys/types.h>
#include <fcntl.h>
#include <string>
#include <vector>
#include <map>
#include <iostream.h>
#include <fstream.h>
#include <functional>
#include <algorithm>
#include <list>
#include <OB/CORBA.h>
#include <OB/CosNaming.h>
#include "cmdLineProc.h"
#include "/usr/home/lemonte/reporter/server/FRUMDefines.h"
#include "/usr/home/lemonte/reporter/server/FRUMCodes.h"
#include "/usr/home/lemonte/cache/Cache_skel.h"



typedef map<int, string, less<int> > 		KEYWORDMAP;
typedef map<string , int, less<string> > 	HOST_INDEX_MAP;
typedef map<string, double, less<string> > 	MEASURE_MAP;

class hostInfo {
public:
	char hostName[MAXLINE];
	char typeOfMeasure[MAXLINE];
	MEASURE_MAP measure;
	vector <string> remoteDATA;
	vector <string> remoteCMD;
	vector <string> paramID;
	int  pipeDes[2];
	int  pid;
	//hostType type;    <<<<< later make enumeration either 
	//		    <<<<< router or host
} ;

enum MEASURE_TYPE {BW, LOAD};

class measureInfo {
public:
	string alias;
	MEASURE_TYPE measureType;
	string hostName;
	int  port;
	int  pipeDes[2];
	int  pid;
	string measureValue;
} ;

typedef struct{
  char line[500];
}LINE;

typedef struct{
	unsigned int day;
	unsigned int month;
	unsigned int year;
}HOLIDAY;

typedef struct{
	char type[64];
	char name[64];
}MEASUREMENT;

typedef struct{ 
	string nameServerHostName;
	int portNumber;
}COMMAND_LINE; 

typedef struct{ 
	Cache_var cacheRef;
	unsigned int errCode;
}CACHE; 



enum measureCondition {COMMON, EMERGENCY};

extern int exeChild(
			measureInfo *, 
			int*, 
			int, 
			char** , 
			CORBA_COMMAND_LINE * 
			);
extern int createArchive(
			int, 
			vector <measureInfo> *, 
			struct tm *
			);
extern int updateArchive(
			vector<measureInfo> *, 
			long, 
			long, 
			struct tm *
			);
extern int archiver(
			int, 
			vector <measureInfo> *, 
                   	struct tm *, 
			long, 
			measureCondition
			);
extern int getTopology(
			char * , 
			hostInfo *, 
			HOST_INDEX_MAP *
			);
extern int getConfiguration(
			char *, 
			vector <measureInfo> *, 
			hostInfo *, 
                        HOST_INDEX_MAP *, 
			struct tm *,
		 	measureCondition *
		 	);
extern CACHE setupCache(
			vector <measureInfo> * ,
			char *,
			int,
			int,
			int,
			char**
			);
extern char* NumToMonth(
			int
			);
extern int cacheData(
			vector <measureInfo> *,	// current measures
			int,			// number of hosts
			CACHE,			// cache reference
			long			// current time
			);

#endif /* _COLLECTOR_H_ */
