#include "collector.h"
#include "stdlib.h"

#define DUMP

int
main(int argc, char *argv[])
{
  char		*p,
		line[MAXLINE],
  		processID[NAMELENGTH];
  long 		now;
  int 		i,j,k,
  		numHosts = 0,
  		process,
  		rv;  
  struct tm 	*presentTime ;
  struct tm 	holidays[MAXHOLIDAYS];

  vector <measureInfo>  measures;

  HOST_INDEX_MAP hostIndex;
  hostInfo	host[MAXNODES];

  measureCondition currentConditions;

  cout << "27" << endl;
  // 
  //  Check command line arguments
  //
  CORBA_COMMAND_LINE cmdLine;
  cmdLine = getCommandLineParameters(argc, argv);
  if((cmdLine.portNumber == -1) || 
	(cmdLine.nameServerHostName == "ERROR")) {
   	cout << "Main:  bad command line" << endl;
   	exit(-1);
  }
  cout << "nameServer: " << cmdLine.nameServerHostName << endl;
  cout << "portNumber: " << cmdLine.portNumber << endl;
  cout << "configFile: " << cmdLine.configFile << endl;

  //
  // Read and Verify the configuration file
  // 
  rv = getConfiguration(cmdLine.configFile.c_str(), &measures,
		host, &hostIndex, holidays, &currentConditions);
  if(rv < 0) {
	cout << "Error in Configuration file " << endl;
	exit(-1);
  }

#ifdef DUMP
  cout << " -- Measure info after Get Configuration -----" << endl;
  for(i=0;i<measures.size();i++) {
	cout << " alias=" << measures[i].alias ;
	cout << " host =" << measures[i].hostName;
	cout << " BW = " << measures[i].measureType << endl;
  }
  cout << " ---------------" << endl;
#endif


  // Setup Software Cache
  //
  CACHE softCache;
  softCache = setupCache(&measures, \
	cmdLine.nameServerHostName.c_str(), \
	cmdLine.portNumber, numHosts, argc, argv);
  if( softCache.errCode < 0) {
	cout << "Error setting up software Cache" << endl;
	exit(-1);
  }


  // Get the present Time 
  time(&now);
  presentTime = localtime(&now);

#ifdef DUMP
  cout << "---" << presentTime->tm_year<< endl;
#endif

  // create the archive directory tree
  rv = createArchive(numHosts, &measures, presentTime);
  if(rv < 0) {
	cout << " Error in create archive file " << endl;
	exit(-1);
  }

  //
  // Fork children and setup pipes
  //
  int	filedes[2];
  int 	flags;
  for(i=0; i < measures.size(); i++) {
	rv = pipe(filedes);
	if (rv < 0) 
		exit(-1);

	pipe(measures[i].pipeDes);
	if (rv < 0) 
		exit(-1);

	process = fork();
	if (process == 0) 
		break; 

	rv = dup2(filedes[1], measures[i].pipeDes[1]);
	if (rv < 0) 
		exit(-1);
	rv = dup2(filedes[0], measures[i].pipeDes[0]);
	if (rv < 0) 
		exit(-1);

	if( (fcntl(measures[i].pipeDes[0], F_SETFL, O_NONBLOCK)) < 0)
		exit(-1);
	if( (flags = fcntl(measures[i].pipeDes[0], F_GETFL) ) < 0)
		exit(-1);
	measures[i].pid = process;
  }

  // 
  // Normal Processing
  // 
  if(process != 0) {  
	char 		*tokptr, *strptr;
	const 		char* holder;
	long 		sampleRate = 60;
	double 		value;
	HOST_INDEX_MAP :: iterator indexp;

#ifdef DUMP
  cout <<"Parent found" << endl;
#endif
    	//
    	//Parent processing
    	//
    	sleep(5);
    	time(&now);
    	presentTime = localtime(&now);
    	rv = updateArchive(&measures, now, sampleRate, presentTime);
    	if(rv < 0) {
      		cout << "Problems updating archive" << endl;
      		for(i=0;i<measures.size();i++) 
        		kill (measures[i].pid, SIGKILL);
      		exit(-1);
    	}

	string	stamp, fileName;
	long	fileTimeStamp, lastMeasuredTime;
	for(;;) {
 		// Get the present Time 
		time(&now);
		presentTime = localtime(&now);

 		// Start the children 
		cout << " --- Starting Children --- " << endl;

		for(i=0; i < measures.size(); i++) { 
			rv = write(measures[i].pipeDes[0],"go",MAXLINE);
  			cout << "PARENT: send go to -- ";
			cout << measures[i].alias << endl;
			measures[i].measureValue = NODATA;
		}

 		// Wait for the specified amount of time
		sleep( 15 );
		//sleep( sampleRate - ( now % sampleRate));

		// Gather data from children
		time(&now);
		cout << "--- gathering data --- " << endl;
		for(i=0;i<measures.size(); i++) {
			fileName = measures[i].alias + ".BW.data";
			ifstream datafile(fileName.c_str(), ios::in);
			datafile >> measures[i].measureValue;
			datafile >> stamp;
			datafile.close();
			sscanf(stamp.c_str(), "%ld", &fileTimeStamp);
			if(fileTimeStamp < lastMeasuredTime)
				measures[i].measureValue = "NA";
		}
		//
		// Cache the data
		rv = cacheData(&measures,numHosts,softCache, now);
		if(rv < 0) {
			cout << " Error caching Data " << endl;
			cout << " ** error return value = " <<rv<< endl;
			exit(-1);
		}
		//
		// Archive the data 
        	//
      		for(i=0; i<measures.size(); i++) {
			cout << measures[i].alias << " --"; 
			cout << " " << measures[i].measureValue << endl;
      		}
	
      		if( archiver( numHosts, &measures, presentTime, 
		      	now, currentConditions) < 0)  
			exit -1;
#ifdef DUMP
  cout <<"after archiving data" << endl;
#endif
    	} // Parent normal processing  for loop
	/*
     	* TESTING....BREAK for loop to Kill all children
     	*
     	*/
     	for(i=0; i< measures.size(); i++) 
		kill (measures[i].pid, SIGKILL);
    
  } // Parent if statement

  else {
	int childPid;
	childPid = exeChild(&measures[i],filedes,argc, argv, &cmdLine); 
	kill(childPid, SIGKILL);
	cout << " *************** KILLED A CHILD *********** " << endl;
  }

  exit(0);
}

