#include <OB/CORBA.h>
#include <OB/CosNaming.h>
#include "collector.h"
#include <sys/stat.h>
#include <unistd.h>
#include <fstream.h>


CACHE
setupCache(vector<measureInfo> 	*measures, 
	char 		*nameServerHostName,
	int 		nameServerPortNumber,
	int 		numHosts,
	int 		argc, 
	char 		*argv[]
	)
{
  
  CORBA_ORB_var orb = CORBA_ORB_init(argc, argv); 
  CORBA_Object_var obj;  
  try
    {
      obj = orb -> get_inet_object(nameServerHostName, 
			nameServerPortNumber, "DefaultNamingContext");
    }
  catch(const CORBA_ORB::InvalidName&)
    {
      cout << "service not available" << endl;
      exit(-1);
    }
  if(CORBA_is_nil(obj))
    {
      cout << "object refernce is invalid" << endl;
      exit(-1);

    }
  
  CosNaming_NamingContext_var ctx; 
  ctx = CosNaming_NamingContext::_narrow(obj);
  
  if(CORBA_is_nil(ctx))
  {
      cout << "object doesn't implement NamingContext" << endl;
      exit(-1);
  }
  if(CORBA_is_nil(obj))
    {
      cout << "object refernce is invalid" << endl;
      exit(-1);

    }
  try
  {
    CosNaming_Name instanceCache;
    instanceCache.length(1);
    instanceCache[0].id = CORBA_string_dup("SoftwareCache");
    instanceCache[0].kind = CORBA_string_dup("");
    CORBA_Object_var Cache_Obj = ctx -> resolve(instanceCache);

    Cache_var clientCache = Cache::_narrow(Cache_Obj);
    assert(!CORBA_is_nil(clientCache));
    
    cout << " before SOFTWARE Cache call " << endl;
    
    stringArray paramIds;
    string tmpString;
    int i, j;
    for(i=0;i< (*measures).size(); i++) {
	//tmpString = host[i].paramID[j];
        //paramIds.append((const char*)tmpString.c_str());
        paramIds.append((CORBA_String_var)(*measures)[i].alias.c_str());
    }
    for(i=0;i<paramIds.length();i++){
	cout << "paramId["<<i<<"] = " << paramIds[i] << endl;
    }

    CORBA_Long rv;
    rv = clientCache->setup(paramIds);
    if(rv < 0)
    {
      cout << "ERROR in cache Setup " << endl;
      exit(-1);
    }

    cout << " ---- " << endl;

    CACHE softCache;
    softCache.cacheRef = clientCache;
    softCache.errCode = 0;
    return(softCache);


  }

  catch( const CosNaming_NamingContext::NotFound& ex)
  {
    cout << "got a not found " << endl;
    cout << " reason = " << ex.why << endl;
    exit(-1);
  }
  catch(CORBA_SystemException e)
  {
    cout << "SystemException: " << e.reason() << endl;
    exit(-1);
  }
}

