#include <OB/CORBA.h>
#include <OB/CosNaming.h>

#include "collector.h"
#include <sys/stat.h>
#include <unistd.h>

#include <fstream.h>
/*
**  cacheData()
**  recieves all data gathered from all hosts.
**  processes the data into a form stuitable to be
**  used by the cache->store()
*/

int
cacheData( vector <measureInfo> *measures,
	int 		numHosts,
	CACHE 		softCache,
	long 		currentTime
	)
{
  unsigned int  i,j, 
		rv = 1;

  double 	tmpData;
  rawHostData 	dataToCache;
  rawHostDataArray data;

  cout << " ------ collector trying to cache " ;
  cout << (*measures).size() << " values " << endl;
  for(i=0; i < (*measures).size(); i++) {
	cout<<" value ["<<i<<"] = "<<(*measures)[i].measureValue<<endl;
      	dataToCache.paramId = \
		(CORBA_String_var)((*measures)[i].alias.c_str()) ;
	
      	if((*measures)[i].measureValue == "NA") {
       		dataToCache.rawData = INVALID;
      	}
      	else {
		sscanf( (*measures)[i].measureValue.c_str(), \
			"%lf", &tmpData);
		dataToCache.rawData = tmpData;
      	}
      	data.append(dataToCache);
  }

  rv = softCache.cacheRef->store(data, (CORBA_Long)currentTime);

  return rv;
}
