#include </usr/include/stdio.h>
#include <unistd.h>
#include "collector.h"

CORBA_COMMAND_LINE 
getCommandLineParameters( int argc,
			char *argv[]
			)
{
  CORBA_COMMAND_LINE cmdLine;

  cmdLine.nameServerHostName = "amaranth3.ices.cmu.edu";
  cmdLine.portNumber = 55555;
  cmdLine.configFile = "config.txt";

  long location;
  char c;

  while ( (c=getopt (argc, argv, "h:p:f:")) != EOF)
  {
    switch(c)
    {
      case 'h':
	cmdLine.nameServerHostName.assign(optarg);
	if(cmdLine.nameServerHostName.size() <=0)
	  cmdLine.nameServerHostName = "ERROR";
      break;
      case 'p':
	cmdLine.portNumber = atoi(optarg);
	if(cmdLine.portNumber <=0)
	  cmdLine.portNumber = -1;
      break;
      case 'f':
	cmdLine.configFile.assign(optarg);
	if(cmdLine.configFile.size() <=0)
	  cmdLine.configFile = "ERROR";
      break;

      case '?':
      default:
	cmdLine.nameServerHostName = "ERROR";
	cmdLine.portNumber = -1;
	cmdLine.configFile = "ERROR";
	cout << "Unknown option found check arguments" << endl;
	cout << "value currently: " << c << endl;
        return(cmdLine);
    }
  }

return(cmdLine);
}
