#include "collector.h"

int archiver(int numHosts, 
             vector <measureInfo> *measures,
	     struct tm *Time,
	     long currentTime, 
	     measureCondition currentConditions)
{

  struct stat status;
  int	Weekend=0, Weekday=1, Emergency=0;
  char 	tmp[NAMELENGTH],
  	day[5];


  string month, year;
  month.assign((const char*)NumToMonth(Time->tm_mon));

  if (month == "ERR") return -1;

  sprintf(tmp, "%d", (Time->tm_year + 1900) );
  year.assign(tmp);

  int i, j, rv;
  string dataFile, tmpString, directory;
  string location;
  ofstream output;
  char DataFileName[400];

  vector <measureInfo>:: iterator measurep= (*measures).begin();

  /*
  sprintf(DataFileName,"archive/RAW/%s/%s/%s" , (*measurep).alias.c_str(), 
					year.c_str(), month.c_str() );

  if( stat (DataFileName , &status) < 0)
    {
    rv = createArchive(numHosts, measures, Time);
    if(rv < 0)
      {
      cout << " ** ERROR in archiver trying to create directories " << endl;
      return(-1);
      }
    }
 */ 
  for(i=0;i<(*measures).size(); i++)
  {

  sprintf(DataFileName,"archive/RAW/%s/%s/%s" , (*measurep).alias.c_str(), 
					year.c_str(), month.c_str() );

  if( stat (DataFileName , &status) < 0)
    {
    rv = createArchive(numHosts, measures, Time);
    if(rv < 0)
      {
      cout << " ** ERROR in archiver trying to create directories " << endl;
      return(-1);
      }
    }
  
    directory= "archive/RAW/";
    directory = directory + (*measurep).alias 
		+ "/" + year + "/" + month;

    dataFile= (*measurep).alias + year + month;
    sprintf(day,"%.2d.dat", Time->tm_mday );
    tmpString.assign(day);
    dataFile += tmpString;

    location = directory + "/" + dataFile;

    // cout << "location = " << location << endl;


    output.open(location.c_str(), ios::app);
    if(!output) return(-1);
    output << currentTime << " " << 
		(*measurep).measureValue << endl;
    output.close();
    measurep++;
  }

  return(1);
}
