
/*************************************************************
  trendAnalysis.cpp
  Author: Ying 

  This program reads the error info from a socket, filters the
  error entries, records the error events and tries to predict if 
  the device that caused the error will fail in the near future.
  ( trendAnalysis is the client of errorMonior )

  Files created:
  devicename.out : history of warnings issued for that device
                   format: rule fired - time of warning
  devicename.dft : time of last warning issued for that device
                   format: time of last warning
**************************************************************/


#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <sys/types.h>
#include <afxsock.h>
#include <winsock.h>  //#include <winsock2.h> #include <winbase.h>
					  //#include "c:\Program Files\DevStudio\VC\mfc\src\SOCKIMPL.H"
#include <winnt.h>
#include <windows.h>
#include <iomanip.h>
#include <stdio.h>
#include <io.h>
#include <errno.h>
#include <process.h>
#include "dft.h"

void errMon();
void Dmod_event_report( char * explanation, int type);

struct FRU fru_devices[NDEVICES];

#define PORTNUM         5000          // Port number
#define HOSTNAME        "localhost"   // Server name string
                                      // This should be changed
                                      // according to the server
int	iReturn;                          // Return value of recv function

struct intpair 
{ 
	long a;
	long b;
} ;

TCHAR Client_szError[100];                   // Error message string
SOCKET ServerSock = INVALID_SOCKET;   // Socket bound to the server
SOCKADDR_IN destination_sin;          // Server socket address
PHOSTENT phostent = NULL;             // Points to the HOSTENT structure
                                      // of the server
WSADATA WSAData;                      // Contains details of the Windows
                                      // Sockets implementation
struct intpair data;

#if defined(__cplusplus)
extern "C"{
#endif /* C++ */

void Client_socketInit()
{
// Socket initialization - connection establishment 

  // Initiate Windows Sockets.   
  if (WSAStartup (MAKEWORD(1,1), &WSAData) != 0) 
  {    
	  Dmod_event_report("Dmod_client: WSAStartup failed", 2); 
	  exit(1);  
  } //end _if_

  // Create a TCP/IP socket that is bound to the server.
  if ((ServerSock = socket (AF_INET, SOCK_STREAM, 0)) == INVALID_SOCKET)  
  {
	  Dmod_event_report("Dmod_client: Allocating socket failed",2);
	  exit(1); 
  }// end _if_

  // Fill out the server socket's address information.
  destination_sin.sin_family = AF_INET;

  // Retrieve the host information corresponding to the host name.
  if ((phostent = gethostbyname (HOSTNAME)) == NULL)  
  {
    Dmod_event_report("Dmod_client: Unable to get the host name",2);
    closesocket (ServerSock);  
	exit(1);  
  } // end _if_

  // Assign the socket IP address.
  memcpy ((char FAR *)&(destination_sin.sin_addr),           
			phostent->h_addr, 
            phostent->h_length);  

  // Convert to network ordering.
  destination_sin.sin_port = htons (PORTNUM);
  
  // Establish a connection to the server socket.  
  if (connect (ServerSock, 
               (PSOCKADDR) &destination_sin, 
               sizeof (destination_sin)) == SOCKET_ERROR)  
  {
    Dmod_event_report("Dmod_client: Connecting to the server failed",2);
    closesocket (ServerSock);    
	exit(1); 
  }// end _if_

}

#if defined(__cplusplus)
}
#endif /* C++ */



void deviceRecordInit()
{
   FILE *fd;
   char str[1024];
   int i,j;

   for (j=1; j <= NDEVICES; j++) 
   {
	   i=j-1;
	   initFRU(fru_devices[i], fruType[i], fruName[i]);

	   //
	   // Initialize warning File to 0 (no warning has been issued) 
	   sprintf(str, "%s.dft", fruName[i]);
	   fd = fopen(str, "w");
	   if (!fd) 
	   {
		   Dmod_event_report("Dmod_client: Error opening warning file",2);
		   exit(1);
	   }//end if(!fd)
	   fprintf(fd, "0");
	   fclose(fd);  

	   //
	   // Create files that keep warning history 
	   sprintf(str, "%s.out", fruName[i]);
	   fd = fopen(str, "w");
	   if (!fd) 
	   {
		   Dmod_event_report("Dmod_client: Error creating warning file",2);
		   exit(1);
	   }//end of if(!fd)
	   fprintf(fd, "0");
	   fclose(fd); 	 
   }//end of for()

}//end of deviceRecordInit()


FILE * openFile(char *fileName)
{
   FILE *fd;

   fd = fopen(fileName, "a");
   if (!fd) {
      fprintf(stderr, "Could not open file for append: %s\n", fileName);
      exit(1);
   }
   return fd;
}

void sendMail(char *stime, char *device)
{
}

void processErrorInfo(FRU_Type type, time_t timeStamp)
{
    int i, warning;
    char str[1024];
    time_t tt;
    FILE *fd;    

    if (type >= NDEVICES) 
	{

	Dmod_event_report("Unrecognized FRU", 3);
	Dmod_event_report("Need to update the mapping table inside file dft.h", 3);
	exit(1);
    } // end if (type)

    //tt = time(NULL);
	tt = timeStamp;
    warning=recordError(tt /*timeStamp */, fru_devices[type]);
    if (warning) 
	{
       /* report rule fired and time of warning on device files */
		for (i=0; i<NRULES; i++) 
		{
			if (fru_devices[type].rulesFired[i]) 
			{
				sprintf(str, "%s.out", fru_devices[type].name);
				fd = openFile(str);
				fprintf(fd, "i=%d\t%s\n",i, ctime(&tt));

				if (i==(NRULES-1)) fprintf(fd,"\n\n\n");
				
				fclose(fd);
 
				fru_devices[type].rulesFired[i]=0;  /* Reset rule */
			}
			else 
			{
				sprintf(str, "%s.out", fru_devices[type].name);
				fd = openFile(str);

				if (i==(NRULES-1)) fprintf(fd,"\n\n\n");

				fclose(fd);
			}// end if-else
		}// end for(i)loop

		/* record time of warning */
		sprintf(str, "%s.dft", fru_devices[type].name);
		fd = fopen(str, "w");
		if (!fd) 
		{
			Dmod_event_report("Error opening .dft file", 3);
			exit(1);
		}
		fprintf(fd, "%d", tt);
		fclose(fd);

		/* send mail to administrator */
		sendMail(ctime(&tt), fru_devices[type].name);
	}// end if (warning)
}// end processErrInfo()

void TrendAnalysis()
{
    int type, t;
    deviceRecordInit();
    Client_socketInit();

    while(1) 
	{
		// Receive data from the server socket.
		iReturn = recv(ServerSock, (char *)(&data), sizeof (data),0);

		// Check if there is any data received. If there is, deal with it.
		/* if (iReturn == SOCKET_ERROR)    
		{
			printf("recv() failed \n");
			break;   
		}
		else if (iReturn == 0)   
		{
			printf("Finished receiving data: Client \n");
			break;   
		}    
			else    
			{ */
				type = ntohl(data.a);
				t    = ntohl(data.b);
			//sscanf(data.a,"%d", &type);
			//sscanf(data.b,"%d", &t);
			processErrorInfo((enum FRU_Type)type, t);
		//	}// end of if-else

	}//end of while

	// Disable receiving on ServerSock.  
	shutdown (ServerSock, 0x00);

    // Close the socket.  
	closesocket (ServerSock);  
	WSACleanup ();
   
}// end of _TrendAnalysis_

/*
void predicter ()
{
	fork()
	//SleepEx((60*1000),FALSE);
	errMon();
	//SleepEx((5*1000),FALSE);
	//Sleep(1000000);
	TrendAnalysis();
}//end of _main_
*/
