/********************************************************************************
Title: Getevents.cpp
Author: Ying
Notes: This program read NT Eventlog and then pass the type info and time info up
*********************************************************************************/


#include <stdio.h>
#include <stdlib.h>
#include <iostream.h>
#include <iomanip.h>
#include <malloc.h>
#include <winsock2.h> //#include <winsock.h> #include <windows.h>
#include <winbase.h>
#include <winnt.h>
#include <process.h>

void Dmod_event_report( char * explanation, int type);

#if defined(__cplusplus)
extern "C"{
#endif /* C++ */
void sendErrorInfo(int coded, DWORD errTime);
#if defined(__cplusplus)
}
#endif /* C++ */


// --------------------------------------------------------------------------------------
// this is the table for the mapping from eventlog source to device type ID
// need to be modified accordingly when applied to defferent machine
// only subkey values under 'system' are related to this mapping table
// those appeared in the 'Application' subkey have nothing to do with the device drivers
//
int type_sorting(LPSTR initial)
{

	if (0 == strcmp(initial, "Print"))
	{
		return 0;  // new printer created
	}
	else if(0 == strcmp(initial, "Eventlog"))
	{
		return 1;  // unexpected system shutdown
	}
	else if(0 == strcmp(initial, "Rdr"))
	{
		return 2;  // master browser has received server anouncement from others ..
	}			   // or the redirector has timeout w/ printer ...
	else if(0 == strcmp(initial, "Service Control Manager"))
	{
		return 3;  // massage in transaction has incorrect size
	}
	else if(0 == strcmp(initial, "BROWSER"))
	{
		return 4;  // Browser is unable to deal with configuration parameter
	}
	else if (0 == strcmp(initial, "aci78xx"))
	{
		return 5;
	}
	else if (0 == strcmp(initial, "Save Dump"))
	{
		return 6;
	}
	else if (0 == strcmp(initial, "Mouclass"))
	{
		return 7;
	}
	else if (0 == strcmp(initial, "Kbdclass")) 
	{
		return 8;
	}
	else if (0 == strcmp(initial, "Sparrow"))
	{
		return 9;
	}
	else
		return -1;
}//end of _type_sorting_

//#if defined(__cplusplus)
//extern "C"{
//#endif /* C++ */

//----------------------------------------------------------
// filter out all the new entries ever since last filtering
// input: last event entry # that ends last filtering
// output: last event entry # that ends this time filtering
//

int periodic_task( int j )   
{
	int coded,i=j;
	DWORD EventType;
	DWORD ErrTime;
	int size; // size of the buffer to store one event entry;
	char key[200];

	// prepare for Eventlog reading 
	DWORD dwReadFlags = EVENTLOG_SEEK_READ + EVENTLOG_FORWARDS_READ,// specifies how to read log 
		  dwReadFlags2 = EVENTLOG_SEQUENTIAL_READ + EVENTLOG_FORWARDS_READ ,
		* pnBytesRead,     // number of bytes read 
		* pnMin,
		  pnMedia1=0,pnMedia2=0; 
	LPBYTE ptr;
	pnBytesRead=&pnMedia1;   
	pnMin=&pnMedia2;
	_EVENTLOGRECORD * lpbuffer;

	//"Application" not applicable
	//as device drivers are only registered under "system" subkey
	char * sourcename= "System"; 
	
	//set up the path to read EventLog;
	strcpy(key, "SYSTEM\\CurrentControlSet\\Services\\EventLog\\");
	strcat(key, sourcename);
	strcat(key, "\\");
	HANDLE open=OpenEventLog( (LPCTSTR)NULL, // pointer to server name 
							  (LPCTSTR)sourcename // pointer to source name 
							);
	// start trial and read pair sequence
	lpbuffer = (_EVENTLOGRECORD*)malloc(10);//randomly sized mallow
	ReadEventLog( (HANDLE)open, // handle of event log  
				  (DWORD)dwReadFlags, //seek-read to continue from last time
				  (DWORD)i,//# of first record
				  (LPVOID)(lpbuffer),
				  (DWORD)0, // number of bytes to read 
				  (DWORD *)pnBytesRead,
				  (DWORD *)pnMin );
	size = *pnMin;
	free (lpbuffer);// return the random sized space
	lpbuffer = (_EVENTLOGRECORD *) malloc(size);//allocate space for real reading
	while(ReadEventLog((HANDLE)open, // handle of event log  
		              (DWORD)dwReadFlags, //seek-read within single filtering
					  (DWORD)i,//number of first record, ignored when sequencial read
					  (LPVOID)(lpbuffer),
					  (DWORD)size, // number of bytes to read 
					  (DWORD *)pnBytesRead,
					  (DWORD *)pnMin ))
	{
		EventType=lpbuffer->EventType;
		ErrTime=lpbuffer->TimeWritten;
		ptr=(LPBYTE)(lpbuffer);
		if ((1==EventType)||(2==EventType))
		{
			coded = type_sorting((LPSTR)(ptr + sizeof(EVENTLOGRECORD)));
			if ( -1 != coded)
			{
				sendErrorInfo(coded, ErrTime);
			}
			else
			{
				Dmod_event_report("Dmod predicter needs updating mapping table", 3);
			}//end of _if-else_
		}//end of _if_              
		free (lpbuffer); // free old sized space

		lpbuffer = (_EVENTLOGRECORD *) malloc(10); // randomly size malloc
		i++; // to read next entry for next new entry
		ReadEventLog( (HANDLE)open, // handle of event log  
				  (DWORD)dwReadFlags, //seek-read to continue from last time
				  (DWORD)i,//# of first record
				  (LPVOID)(lpbuffer),
				  (DWORD)0, // number of bytes to read 
				  (DWORD *)pnBytesRead,
				  (DWORD *)pnMin );
		size = *pnMin;
		free (lpbuffer); // free old sized space
		lpbuffer = (_EVENTLOGRECORD *) malloc(size);//allocate space for real reading
	}//end _while_ 
	free (lpbuffer);
	CloseEventLog(open);
	return (i);
} //end of _periodic_task_

//#if defined(__cplusplus)
//}
//#endif /* C++ */


