/*************************************************************
  errorMonitor.cpp
  Author: Ying

  This program reads the log using NT provided API functions. Then it passes the info about the error category or device that caused the error and
  the time when the error occurred. This information is communicated
  through a socket to the trendAnalysis module. 
  (errorMonitor is the server for trendAnalysis)

  The error log is checked ###every five## minutes for ##new## entries.
**************************************************************/

#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <sys/types.h>
#include <afxsock.h> 
//#include <winsock2.h>
#include <winsock.h>
#include <windows.h>
#include <stdio.h>
#include <io.h>
#include <errno.h>
#include <process.h>

#define INTERVAL  (300*1000) // period of checking event log

void Dmod_event_report(char * explanation, int type);
int periodic_task(int i);

FILE *errLog;
char errLogFile[]="errlog.txt";
int fromlen;
time_t prev_time;

#define PORTNUM               5000    // Port number  
#define MAX_PENDING_CONNECTS  40      // Maximum length of the queue 
                                      // of pending connections      
int	Server_iReturn;                          // Return value of recv function
TCHAR szError[100];                   // Error message string
SOCKET WinSocket = INVALID_SOCKET,    // Window socket
       ClientSock = INVALID_SOCKET;   // Socket for communicating 
                                      // between the server and client
SOCKADDR_IN local_sin,                // Local socket address
            accept_sin;               // Receives the address of the 
                                      // connecting entity
int accept_sin_len;                   // Length of accept_sin
WSADATA Server_WSAData;                      // Contains details of the Windows
                                      // Sockets implementation
struct intpair {
	long a;
	long b;
};

struct intpair Server_data;

/*
sender side:

   data.a = htonl(value1);
   data.b = htonl(value2);
   write(fd,&data,sizeof(data));

recv. side

   read(rd,&data,sizeof(data));
   value1 = ntohl(data.a);
   value2 = ntohl(data.b);
*/

void Server_socketInit()
{
// Socket initialization - connection establishment 

  // Initiate Windows Sockets.  
  if (WSAStartup (MAKEWORD(1,1), &Server_WSAData) != 0) 
  {    
	  Dmod_event_report("Dmod_server: WSAStartup failed. Error", 2);    
	exit(1);  
  }// end _if_

  // Create a TCP/IP socket, WinSocket.
  if ((WinSocket = socket (AF_INET, SOCK_STREAM, 0)) == INVALID_SOCKET)  
  {
	  Dmod_event_report("Dmod_server: Allocating socket failed. Error",2);
    exit(1); 
  }//end _if_

  // Fill out the local socket's address information.
  local_sin.sin_family = AF_INET;  local_sin.sin_port = htons (PORTNUM);  
  local_sin.sin_addr.s_addr = htonl (INADDR_ANY);

  // Associate the local address with WinSocket. 
  if (bind (WinSocket, 
            (struct sockaddr *) &local_sin, 
            sizeof (local_sin)) == SOCKET_ERROR)  
  {
	  Dmod_event_report("Dmod_server: Binding socket failed. Error",2); 
    closesocket (WinSocket);  
	exit(1);  
  }// end _if_

  // Establish a socket to listen for incoming connections.
  if (listen (WinSocket, MAX_PENDING_CONNECTS) == SOCKET_ERROR) 
  {
	  Dmod_event_report("Dmod_server: Listening to the client failed. Error",2);
    closesocket (WinSocket);   
	exit(1);
  }// end _if_

  accept_sin_len = sizeof (accept_sin);

  // Accept an incoming connection attempt on WinSocket.
  ClientSock = accept (WinSocket, 
                       (struct sockaddr *) &accept_sin, 
                       (int *) &accept_sin_len);

  // Stop listening for connections from clients.  
  closesocket (WinSocket);
  if (ClientSock < 0) //INVALID_SOCKET) 
  {
	  Dmod_event_report("Dmod_server: Accepting connection with client failed",2);
  exit(1); 
  }//end _if_
  
}//end of _SocketInit_

#if defined(__cplusplus)
extern "C"{
#endif /* C++ */
void sendErrorInfo(int code, DWORD errTime)
{
	int Server_iReturn;
#if 0
    printf("got: %d %d from parser, sending to trend analysis module\n",
	    code, errTime);
#endif
	Server_data.a = htonl(code);
	Server_data.b = htonl(errTime);
    //sprintf(strs, "%d %d\n", code, errTime);
    Server_iReturn = send(ClientSock, (const char *)(&Server_data), sizeof(Server_data),0);
	if (Server_iReturn <= 0)// SOCKET_ERROR)    
	{
		Dmod_event_report("Dmoe_server: send failed", 2);
		exit(0);   
	} 
}//end of _sendErrorInfo_
#if defined(__cplusplus)
}
#endif /* C++ */

void errMon()
{
    int i=1;

    Server_socketInit();

	// infinite loop to filter constantly system event log 
	// for new entries 
    while (1) 
	{
    i = periodic_task(i);   
    SleepEx(INTERVAL,FALSE); //notice the fine granuality of time unit in NT
    }//end of _while_

	// Disable both sending and receiving on ClientSock.
	shutdown (ClientSock, 0x02);  
	// Close ClientSock.  
	closesocket (ClientSock);
	WSACleanup ();
}// end of _errMon_

//void main ()
//{
//	errMon();
//}// end of _main_


