
/***********************************************************
 Description: implementation of DFT algorithm 
 Author: Ying 
 ***********************************************************/
//#include <afxsock.h>
#include <stdio.h>
#include <process.h>
#include "dft.h"


void resetBuffer(struct FRU device)
{
   device.top=0;
   device.counter=0;
}

void addBufferEntry(struct FRU device, struct Element element)
{
   device.top = (device.top+1)%BUFFER_SIZE;
   device.counter++;
   device.buffer[device.top]=element;
}

int frame(int top, int number)
{
  return((top-number+BUFFER_SIZE)%BUFFER_SIZE);
}

int test4in1Rule(struct FRU device)
{
  struct Element *buffer=device.buffer;
  int top=device.top;
  LONG ti;

  ti=buffer[top].arrivalTime - buffer[frame(top, 4)].arrivalTime;
  if (ti <= ONE_DAY) {
     device.rulesFired[1] = 1;
     return 1;
  }
  return 0;
}

void computeEDIs(struct FRU device)
{
  LONG  cumFrameSize;
  int i, j, k, fi;
  struct Element *buffer=device.buffer;
  int top=device.top;
  
#ifdef DEBUG
  printf("device=%d\n", device.type);
#endif

  for (i=FRAME_COUNT-1; i>0; i--) 
  {
      fi=0;
      for (j=i; j>0; j--)
      {
	  cumFrameSize=0;
	  device.edi[i][fi] = 1;
	  for (k=j-1; k>=0; k--)
	  {
	      cumFrameSize += buffer[frame(top,k)].frameSize;
	      if ( cumFrameSize <= buffer[frame(top,i)].frameSize/2 )
		   device.edi[i][fi] += 1;
	  }
#ifdef DEBUG
          printf("EDI[%d][%d]=%d\n", i, fi, device.edi[i][fi]);
#endif
	  fi++;
      }
  }
}

int test3_3Rule(struct FRU device)
{
	int **edi = (int **)&(device.edi);

  if ( ( (edi[3][1] >= 3) && 
         ((edi[3][0] >= 3) || (edi[3][2] >=3)) ) ||
       ( (edi[2][0] >= 3) && (edi[2][1] >= 3) ) )
  {
     device.rulesFired[2] = 1;
     return 1;
  }
  else return 0;
}

int test2_2Rule(struct FRU device)
{
	int **edi= (int **) &(device.edi);

  if ( ( (edi[2][0] >= 2) && 
         ((edi[1][0] >= 2) || (edi[3][0] >=2)) ) ||
       ( (edi[3][1] >= 2) && (edi[2][1] >= 2) ) )
  {
     device.rulesFired[3] = 1;
     return 1;
  }
  else return 0;
}

int test4DecreasingRule(struct FRU device)
{
  struct Element *buffer=device.buffer;
  int t0, t1, t2, t3;
  int top=device.top;

  t0 = buffer[top].frameSize;
  t1 = buffer[frame(top,1)].frameSize;
  t2 = buffer[frame(top,2)].frameSize;
  t3 = buffer[frame(top,3)].frameSize;
      
  if ( ( (t0 < t1) && (t1 < t2) && (t2 < t3) ) &&
       ( (t0 <= t1/2) || (t1 <= t2/2) || (t2 <= t3/2) ) )
  {
     device.rulesFired[4] = 1;
     return 1;
  }
  else return 0;
}      

int applyDFTRules(struct FRU device)
{
    int *rules=device.rulesFired;

    if (device.counter>=5) {
       computeEDIs(device);
       test4in1Rule(device);
       test3_3Rule(device);
       test2_2Rule(device);
       test4DecreasingRule(device);
       if (rules[0] || rules[1] || rules[2] || 
	   rules[3] || rules[4])
           return 1;
       else
	   return 0;
    }
    else 
    {
#ifdef DEBUG
       printf("%d error entries. Not enough entries to apply DFT\n",
	      device.counter);
#endif
       return 0;
    }
}

int recordError(LONG arrivalTime, struct FRU device)
{
   LONG ltmp;
   struct Element tmp;
   int *rules=device.rulesFired;
   
   if (device.lastArrivalTime >= 0) { 
      ltmp = arrivalTime-device.lastArrivalTime;
      /* check for tuples - errors less than 2 minutes apart */
      if (ltmp <= TUPLE_THRESHOLD) {
	 device.lastArrivalTime=arrivalTime;
	 return 0;
      }

      /* check for two in 1 rule */
      if (ltmp <= ONE_HOUR) device.rulesFired[0] = 1;  
      /* filter transient errors */
      if (ltmp > DFT_THRESHOLD) {
	  resetBuffer(device);
	  rules[0]=rules[1]=rules[2]=rules[3]=rules[4]=0;
	  device.lastArrivalTime=-1;
      }
      else
	  tmp.frameSize=ltmp;
   }
   else
	  tmp.frameSize=-1;
   tmp.arrivalTime=arrivalTime;
   device.lastArrivalTime=arrivalTime;
   device.errorCount++;
   addBufferEntry(device, tmp);

#ifdef DEBUG
   printf("adding entry to buffer %d: Tarr=%ld frameSize=%d\n", 
	   device.type, arrivalTime, tmp.frameSize);
   printf("Buffer Top=%d  errorCount=%d\n", device.top, device.errorCount);
#endif

   if (device.counter >= 5) return(applyDFTRules(device));
   else return 0;
}

void initFRU(struct FRU device, enum FRU_Type type, char *name)
{
  device.type = type;
  device.name = name;
  device.counter=0;
  device.top=0;
  device.lastArrivalTime=-1;
  device.rulesFired[0]=device.rulesFired[1]=device.rulesFired[2]=0;
  device.rulesFired[3]=device.rulesFired[4]=0;
  device.errorCount=0;
}

