#define _BSD_SOURCE		/* to allow SGI to process select() */

#include <unistd.h>
#include <sys/types.h>
#include <sys/time.h>

#include <iluxport.h>

#include <lisp.h>  /* These are in the CMUCL C sources */
#include <arch.h>


static int (*read_fn) (int fd, unsigned long msec) = NULL;
static int (*write_fn) (int fd, unsigned long msec) = NULL;

// CMUCL tags the 3 lowest order bits CMUCL scheme, but uses the rightmost tags
// for odd and even fixnums, so shift two and get 30 bits of data.

#ifdef CMUCL
#define FixnumToInt(v)	((v)>>2) 
#endif /* CMUCL */

#define MILLISECONDS(x)	(((x)==NULL)?0:((x)->ft_s * 1000 + (((x)->ft_t * 1000) / ilu_FineTimeRate)))

int ilucmucl_OutputPossibleP (int fd)
{
  static fd_set writefds;
  int width, stat;
  static struct timeval to = { 0, 0 };

  width = fd + 1;
  FD_ZERO(&writefds);
  FD_SET(fd, &writefds);
  stat = select (width, NULL, &writefds, NULL, &to);
  if (stat > 0 && FD_ISSET(fd, &writefds))
    return 1;
  else
    return 0;
}

static void internal_read_wait (int fd, ilu_boolean *sure, ilu_FineTime *limit)
{
  if (read_fn != NULL)
    *sure = FixnumToInt((*read_fn)(fd, (limit == NULL) ? 0 : MILLISECONDS(limit)));
  else
    *sure = 0;
}

static void internal_write_wait (int fd, ilu_boolean *sure, ilu_FineTime *limit)
{
  if (ilucmucl_OutputPossibleP(fd))
    {
      *sure = 1;
    }
  else
    {
      if (write_fn != NULL)
	*sure = FixnumToInt((*write_fn)(fd, (limit == NULL) ? 0 : MILLISECONDS(limit)));
      else
	*sure = 0;
    }
}

void ilucmucl_SetWaitTech (int (*read_wait) (int fd, unsigned long timetowait),
			   int (*write_wait) (int fd, unsigned long timetowait))
{
  static ilu_WaitTech wait_tech;

  read_fn = read_wait;
  write_fn = write_wait;
  wait_tech.wt_read_wait = internal_read_wait;
  wait_tech.wt_write_wait = internal_write_wait;
  ilu_SetWaitTech (&wait_tech);
}

static lispobj hook = 0;

/*Inside(obj's server, obj's type)*/
static void kernel_interest_hook (ilu_Object kobj, int vi)
{
  unsigned long index = (unsigned long) ilu_GetLanguageSpecificObject (kobj);
  unsigned long newindex;
  ilu_Class cl = ilu_ClassOfObject(kobj);
  
  /* printf("Interest:  %s %4u %s\n", (vi == 0) ? "NO  " : "YES", index, ilu_SBHOfObject(kobj)); */

  if (index != 0 &&
      internal_interest_hook != 0 &&
      ((!ilu_TrueInstanceP(kobj)) || (cl->cl_collectible)) &&
      (((vi == 0) && ((index & 0x1) != 0)) ||
       ((vi != 0) && ((index & 0x1) == 0))))
    {
      // Note that the call of lisp functions from C in CMUCL is limited to functions
     // of up to 3 arguments.
      newindex = fixnum_value(funcall2(internal_interest_hook, make_fixnum(index), make_fixnum(vi)));
      if (newindex != index)
	{
/*	  printf("           LSPO changed to %u\n", newindex); */
	  ilu_RegisterLanguageSpecificObject (kobj, (void *) newindex);
	}
    }
}

void ilucmucl_SetInterestHook (lispobj hook)
{
  internal_interest_hook = hook;
  ilu_SetNoter (&kernel_interest_hook);
}
