\begindata{text,756864}
\textdsversion{12}
\template{default}
\define{footnote

attr:[Flags OverBar Int Set]
attr:[FontSize PreviousFontSize Point -2]}
\define{helptopic
}
\majorheading{Making the Most of Andrew

\smaller{\smaller{\smaller{As published in the \italic{Linux Journal}, 
November, 1994}}}

}

In this article, Terry Gliedt completes our tour through the Andrew project 
with details on using and customizing AUIS applications.


\heading{Introduction}


AUIS had its roots in 1982 when Carnegie Mellon University and the IBM 
Corporation decided to jointly develop a campus computing facility based on 
personal computers to replace the time-sharing system then on campus.  IBM 
provided not only generous funding, but also some talented individuals and 
access to IBM development programs.


The result was a graphical user interface we know as the Andrew User 
Interface System and a file system, the \italic{Andrew File System}.  The 
file system formed the basis of Transarc Corporation's \italic{Distributed 
File System} (DFS) and is as part of the Open System Foundation software.


The \italic{\bold{Andrew Consortium}}, composed of a number of corporations 
and universities, funds the current development of AUIS.  AUIS is available 
on a wide variety of platforms including Linux, AIX, Solaris, Ultrix, HP UX 
as well as others. \



In early June, version 6.3 of the Andrew User Interface System (AUIS) was 
released by the Andrew Consortium.  This led to the release of several 
packages aimed at people interested in a word processor, a program source 
editor and a multi-media mail agent.  You may find these packages in 
\bold{pub/Linux/X11/andrew/auis63L*} at \bold{sunsite.unc.edu}.


\heading{Other Applications}


In previous articles I focused a great deal on the \italic{ez} editor and 
on the multi-media user mail agent, \italic{messages,} but these are only 
two of a rich set of applications.  Here are a few other applications that 
you will find useful:


\bold{bush} (see Figure 1.) provides a graphical interface to the file 
system.  It shows the directory hierarchy, filenames and their attributes. 
 It also provides a window where the \italic{ez} editor will run as well as 
a means to invoke an arbitrary command on a file.  With \italic{bush} you 
can sort the list, rename, and delete files too.


\begindata{image,1463168}
format: gif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\enddata{image, 1463168}
\view{imagev,1463168,6,0,0}
	\bold{Figure 1}. Bush Showing a Tree of Directories


\bold{chart} allows you to create simple graphs from numeric data.  The 
data can be presented as a histogram, pie chart, or line graph. \



\bold{ezdiff} is not actually an application, but rather a procedure you 
can call from all \italic{ez} windows.  This is used to run the 
\italic{diff} command on the data in two windows and then interactively see 
the difference between the files. \



To try \italic{ezdiff}, edit two files (e.g. "\italic{ez /etc/hosts.deny 
/etc/hosts.equiv}").   In each window, select the \italic{Start} item on 
the \italic{Ezdiff} menu card.  As you select the \italic{Next} item on the 
\italic{Ezdiff} menu card, the differences \indent{in each file} are shown 
as highlighted data.  This makes it very easy to copy lines selected in one 
window and paste them in the other.  And yes, \italic{ez} correctly 
remembers the locations of all the other differences when you make changes 
to either document.  This is a life saver when looking at various versions 
of a file.


\bold{figure} (see Figure 2) is a fairly conventional drawing editor.  The 
files usually have an extension of ".fi". Figure can create a document with 
lines, circles, boxes, and other insets (e.g. rasters or text), and then 
move them around, reshape, etc.  Since figure creates an ATK datastream, 
you can easily insert figures in other AUIS documents.


\begindata{image,756352}
format: gif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==
\enddata{image, 756352}
\view{imagev,756352,1,0,0}
	\bold{Figure 2}. Sample AUIS Figure \



\bold{pipescript} (see Figure 3.) reads data from stdin and shows it in a 
window. This is very convenient with pipes, because the output data does 
not disturb your \italic{xterm} window and yet is not in a file you need to 
remove. The data can be conveniently scrolled, searched or saved. I use it 
all the time for commands like "\italic{tar tzvf auis63L1-wp.tgz | 
pipescript}".


\begindata{image,756224}
format: gif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\enddata{image, 756224}
\view{imagev,756224,2,0,0}
\bold{	Figure 3}. grep InitializeClass *.c | \bold{pipescript}


\bold{raster} provides a simple means to edit digitized pictures (called 
rasters). The data must be in AUIS datastream format.  The \bold{pbmplus} 
package (available on sunsite) provides a wide set of filters to convert 
between various forms of digitized data.  For example, to convert from a 
TIFF to an AUIS-raster, I'd use this command:


\indent{tifftopnm test.tif | ppmquant 256 | ppmtopgm | pgmtopbm | 
pbmtocmuwm > test.ras

}
\bold{typescript} (see Figure 4.) provides an alternative to 
\italic{xterm}.  You enter commands to your shell in the input window and 
the results are shown in the same window where they can be scrolled, 
searched or saved.  \italic{Typescript} does not support curses like 
\italic{xterm} does, so you cannot run \italic{vi} or \italic{bash} in a 
\italic{typescript}, for example. However, you can use the \italic{tcsh} or 
\italic{pdksh} (\italic{ksh}) shells.


\begindata{image,756096}
format: gif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\enddata{image, 756096}
\view{imagev,756096,3,0,0}
	\bold{Figure 4}. Sample Typescript Window


\italic{Typescript} has several other features that I find very useful. 
 The README for the word processing package describes how you can cause the 
current working directory to be kept in the title of the \italic{typescript} 
window.  \italic{Typescript} is "smart" about these paths, too.  Notice in 
Figure 4. that the path shown in the title of the window is "~", my home 
directory, and not a fully qualified path.


\italic{Typescript} supports use of several PC keys to make it easier to 
enter commands.  The Cursor-Left and Cursor-Right keys can be used to edit 
the command I am entering (regardless if my shell supports this).  The Home 
and End keys will move the cursor to the beginning or end of the line (or 
selected area).  The cursor keys are also mapped to allow me to move up and 
down the the command history. Cursor-Up gets the previous command entered, 
Cursor-Down the one after.


In my opinion an even more useful feature is \underline{command} 
completion.  If I type "ls" and then press Cursor-Up, I get the previous 
command that began with "ls".  \underline{File} completion is supported 
with the tab key.  If I enter "ls src/tp" and then press the tab key, 
\italic{typescript} will complete the path "src/tp" to "src/tpg-config" (in 
my case). It makes entering paths to files ten times easier. I love it!


If I enter a command like "ls /etc", the window will likely fill and scroll 
automatically. If I want to see the beginning of the scrolled data, I must 
use the mouse (or Page-Up/Down keys) to scroll.  However, if I enter "ls 
/etc control-J" (where I enter the command with a control-J keystroke, 
rather than the normal Enter), the command is executed, but the output is 
pushed to the top of the current window so I do not need to scroll.


\italic{Typescript} also allows me to create my own menus in the file 
\bold{~/.shmenu}.  In Figure 4, you can see I have a menu card 
\italic{Internet} on the menubar.  This is from my own \italic{.shmenu} 
file which looks like this:


\example{#	User's .shmenu file

#	Do help .shmenu for more information.

#	Establish the pop up menus for the typescript window.

Internet~20,FTP<->Sunsite export~15:ftp sunsite.unc.edu

Internet~20,FTP<->CMU~16:ftp.andrew.cmu.edu

Internet~20,FTP_Anonymous~20:anonymous

Internet~20,FTP_Ident~21:tpg@mr.net

Internet~20,FTP_bin~22:bin

Internet~20,FTP_submissions~23:cd pub/next/submissions

Internet~20,Telnet->CMU~31:telnet ftp.andrew.cmu.edu

Internet~20,Bring Slip Up~40:/usr/local/bin/slipup

Internet~20,Take Slip Down~41:/usr/local/bin/slipdown

}
\heading{Using Filters}


All AUIS applications provide a means to use a filter to modify a selected 
area.  The \italic{Misc} menu card provides items to fold data to lower 
case, upper case or to "flow" the data together.  To use filters, simple 
select an area (so it is highlighted) and select the correct item.  There 
is also a item (\italic{Filter Prompt}) which allows you to specify your 
own filter.  For instance, specifying the filter \italic{sort} would cause 
the select text to be sorted - just like you would in a conventional Unix 
pipe.


\heading{Personalizing AUIS}


You can tailor the behavior and appearance of your AUIS applications with 
your own \bold{~/preferences} file.  Each time an applications begins, it 
checks a set of resources you have specified in your \italic{preferences} 
file.  The resources in the \italic{preferences} file are similar to other 
X-resources.  A sample \italic{preference} file is provided in 
\bold{/usr/andrew/sample.preference}.  If you edit this file you will find 
lines like these:


\example{Messages.Geometry: 750x600

Figure.BackgroundColor: White

*.BackgroundColor: LightSkyBlue4

}
The first field (e.g. Messages, Figure or "*") is the application name. The 
asterisk means it applies to all AUIS applications.  AUIS resource names 
are case insensitive, so "Messages" is the same as "messages".  The second 
field is specific to the application. Most of these, like "Geometry" or 
"BackgroundColor", will be pretty obvious.  Others, like 
"XStyleSelections", will be a mystery unless you read the preferences help 
file. (\italic{auishelp preferences}). Some of these resources are specific 
to a single application and others apply to all AUIS applications.


The third field (after the colon) is the value of the resource and is tied 
directly to the second field.  These resources can be rather confusing.  To 
make it easier to understand what resources can be set for which 
applications, a specialized preferences editor was written, \bold{prefed}.


As you can see in Figure 5., the \italic{prefed} window is divided into 
four areas.  You select the application name in the upper left hand window 
("EZ" in this case). The upper right hand window has the list of resource 
names ("OverwriteFiles"). The middle window shows you what the current 
setting is and allows you to change it.  Finally, the bottom window 
provides a description of what the resource controls.


\begindata{image,755968}
format: gif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\enddata{image, 755968}
\view{imagev,755968,4,0,0}
	\bold{Figure 5}. Modifying preferences with prefed


When you select the item \italic{Save}, your \bold{preferences} file will 
be modified, just as you would expect with any editor.  The addition of 
\italic{prefed} has made it much easier to figure out this bewildering 
array of resource names.


When an application initializes, it searches for all resources that apply 
to that application.  The resources are applied \underline{in the order 
that they are read}. The search order is first in \italic{~/preferences} 
and then in the machine-wide "preferences" file in 
\italic{/usr/andrew/lib/global.prf}. Thus, if you specify any resources 
that apply against all applications (e.g. *.BackgroundColor), these should 
be at the \underline{bottom} of your preferences file. This is sightly 
different than resources for conventional X-applications.


One thing to keep in mind is that \italic{preferences} are only read when 
an application initializes.  If you change the \italic{ez} BackgroundColor, 
for example, this will not take effect until you start a new \italic{ez} 
from the command line (from an \italic{xterm} or \italic{typescript}).


\italic{Messages}, the multi-media mail user agent, is unique with respect 
to its treatment of \italic{preferences}.  Since there are a great many 
\italic{preferences} resources for \italic{messages}, a long time ago the 
author of \italic{messages} added his own specialized way to set 
\italic{preferences} for \italic{messages} by selecting the \italic{Set 
Options} item on the \italic{Other} menu card. \



\heading{Printing}


Printing is an area where it seems everyone needs to "have their own way". 
 AUIS printing involves two steps.  Applications generate \italic{groff} 
data and the first step is to format this to generate the printer-specific 
data stream.  The second step is to simply deliver the stream to the 
printer.  These two steps can be overridden with your \italic{preferences}. 
 The default \italic{preferences} settings are:


\example{*.FormatCommand: /usr/andrew/etc/atkprint /tmp/%s.n |

*.PrintCommand:  lpr -P$PRINTER

}
These two commands are joined in a pipeline (hence the pipe character, "|", 
at the end of \italic{FormatCommand}).  When this command is built, the 
"%s" will be changed to the name of the \italic{groff} input file.


Many AUIS applications actually generate PostScript data with just a simple 
\italic{groff} "wrapper" around the PostScript.  In the next major release, 
AUIS will generate PostScript directly and the need for a 
\italic{FormatCommand} will be eliminated.  But for today if you are having 
difficulty, you might want to copy \italic{/usr/andrew/etc/atkprint} and 
make your own version which you modify to meet your needs. You can then 
specify your own \italic{FormatCommand} resource to invoke your own version 
of \italic{atkprint}.


Sometimes I want to capture the \italic{groff} input, so I simply make a 
quick \italic{preferences} change \



	*.FormatCommand: cat /tmp/%s.n > /tmp/test.n


to copy in the input file to /tmp/test.n. I can then execute the print 
sequence manually with:


	/tmp/atkprint /tmp/test.n | pipescript


so I can see exactly what's happening in the shell script.  On the other 
end, if I want to simply capture the PostScript, I can change 
\italic{preferences} to:


	*.PrintCommand:  cat > /tmp/test.ps


There are obviously many ways to accomplish either of these steps.  The 
point to remember is that AUIS printing is entirely externalized.  You can 
control it to any degree you need.


\heading{Initialization Files}


At startup AUIS applications look for several initialization files.  There 
are two classes of these, \underline{global} or machine-wide files found in 
\bold{/usr/andrew/lib} and \underline{personal} files, found in your home 
directory.  Each application can have its own initialization file. For 
example, \italic{ez} would check for files in this order:


\indent{~/.ezinit

/usr/andrew/lib/global.ezinit

~/.atkinit

/usr/andrew/lib/global.atkinit

}
If the \italic{.ezinit} file is found, the \italic{global.ezinit} is not 
read.  Similarly, if .\italic{atkinit} is found, the \italic{global.atkinit} 
file is not read. This ordering means that when you create an 
initialization file, you should make it refer to the files that it masks by 
using an "include" statement.  So, if you are going to make a 
\italic{.ezinit} file, you would want to include the \italic{global.ezinit} 
by:


\indent{include /usr/andrew/lib/global.ezinit

include $HOME/.atkinit

}
and your \italic{~/.atkinit} should probably include 
\italic{/usr/andrew/lib/global.atkinit}.


If you don't include the global file, you will not get important default 
settings.  Note, though, that not all programs have global initialization 
files.  When something is defined more than once, the last definition stays 
in effect.


While I used \italic{ez} in this example, this works exactly the same for 
\italic{typescript} or any other AUIS application.  \italic{Typescript} 
would read \italic{~/.typescriptinit}, or if that file did not exist, it 
would read \italic{/usr/andrew/lib/global.typescriptinit} instead.  All 
applications look for \italic{~/.atkinit} and 
 \italic{/usr/andrew/lib/global.atkinit}. These files are described in more 
detail with the command \bold{auishelp initfiles}. \



\heading{Controlling Menus}


In AUIS applications menus are simply a means to call a procedure (method) 
for an object.  AUIS has hundreds of these defined and they provide 
enormous functionality.  To define a menu, edit one of the initialization 
files described previously (a personal initialization file is probably 
best) and add lines like these:


addmenu filter-filter-region-thru-command "Misc,Flow~20"	textview \\

	filter inherit "flowtogether"

addmenu textview-lowercase-word	"Misc,Lower~21"		textview

addmenu textview-uppercase-word	"Misc,Upper~22"		textview

addmenu filter-filter-region		"Misc,Filter Prompt~25"	textview


The entries shown add items like \italic{Flow} and \italic{Lower} to the 
\bold{Misc} menu card. The order of these items is determined by the 
numbers (20, 21, etc.).  When you select a item like \italic{Lower}, the 
procedure \italic{textview-lowercase-word} will be called and the selected 
area will be folded to lower case.


Knowing the procedure names is important to create menu cards. There is no 
fixed list of all the procedures that are in AUIS because the AUIS objects 
are dynamically loaded. To help you find out what is available, select 
\italic{Describe Proc Table} on the \italic{Misc} menu card.  This will 
open a window which displays a list of all the procedures and a short 
description of purpose of each.


A more complex example is shown when the procedure 
\italic{filter-filter-region-thru-command} is called when the \italic{Flow} 
item is selected. In this case the procedure calls the filter 
\italic{flowtogether.} Flowtogether is a simple filter which combines lines 
together to remove excess whitespace and create data in paragraphs. I use 
this filter in \italic{messages} when I want to quote part of some mail and 
make it nicer looking.


Most of the menus you see in the Linux distribution were added using 
addmenu in the various initialization files.  You can add your own menu 
cards by adding addmenu commands in your private initialization files. More 
details on adding menu cards can be found with the command \bold{auishelp 
initfiles}.


\heading{Filetypes}


 If I issue the command \bold{ez test.d}, the data in this file will be an 
AUIS text document, but if I edit the file \italic{test.document}, it will 
be just simply ASCII data.  The difference obviously has something to do 
with the extension of the file.


Linux, like all conventional Unix systems, really has no innate "knowledge" 
of what is in a file, but we all have expectations for what's in the file 
'test.c".  It's just a matter of \underline{convention}. AUIS has its own 
conventions and these are controlled in the file 
\italic{/usr/andrew/lib/global.filetypes} which has entries like these:


addfiletype .Xdefaults	rawtext		"template=rawtext"

addfiletype .c		ctext		"template=c"

addfiletype .h		ctext		"template=h"

addfiletype .d		text		"template=default"

addfiletype .doc	text		"template=default"

addfiletype .help	text		"template=help"


Addfiletype commands allow you to map extensions to inset types so that new 
documents you create with a certain extension will get the proper inset 
type specified by the "template=" keyword.


Editing \italic{.Xdefaults} will have the template \italic{\bold{rawtext}} 
(which will insure that copying an AUIS datastream results in a simply 
ASCII string and not some \bold{bold} text) and editing 
\italic{.Xdefaults.old} results in the \italic{\bold{default}} template 
(which allows you to copy and retain \bold{bold} text) which is probably 
not what you want.  The current AUIS distribution does not allow you to use 
wildcards in addfiletype commands, so you must explicitly map 
\italic{.Xdefaults} and \italic{.Xdefaults.old} individually.  More details 
on filetypes can be found with the command \bold{auishelp initfiles}.


\heading{Key Definitions}


In AUIS applications keystroke combinations are another means to get a 
procedure called for an object.  The same procedures are available for 
keybinding as for menu items. To define a set of keybindings, edit one of 
the initialization files described previously and add lines like these:


addkey compile-build          ^X^E srctextview compile

addkey compile-next-error     ^X^N srctextview compile

addkey compile-previous-error ^X^P srctextview compile

addkey fcomp-complete-command-forward \\eB typescript fcomp inherit

addkey fcomp-complete-filename ^I typescript

addkey fcomp-possible-completions \\e^I typescript


The first line of the example says that when you are in a srctextview inset 
(e.g. editing C-source) the procedure name compile-build will be called 
when you press the keystrokes control-X followed by control-E.  (The "\\eB" 
in the fourth line means you should press the escape key and then shift-b.) 
 You can see a dynamically created list of all the keys that are bound to a 
procedure by selecting the \italic{Describe Bound Keys} item on the 
\italic{Misc} menu card. You can also query what procedure will be called 
for any keystroke by selecting the \italic{Describe Key} item on the 
\italic{Misc} menu card. \



\heading{Conclusion}


AUIS is far more than just \italic{ez} or \italic{messages} - and yet in 
many ways it is no more.  AUIS is built on a toolkit of objects which 
combine to provide a set of tools which are consistent in their look and 
feel and which can be extended or combined with new applications with 
remarkable ease.  In these four articles on AUIS I have not attempted to 
show any of the underlying toolkit.  The Andrew Consortium is dedicated to 
extending and disseminating this technology.  If you think your 
organization could benefit, I'd encourage you to contact the consortium and 
talk with us about what else has been done and what's new.


\heading{For More Information}


A mailing list is available at info-andrew@andrew.cmu.edu (mail to 
info-andrew-request@andrew.cmu.edu for subscriptions).  The newsgroup 
comp.soft-sys.andrew is dedicated to the discussion of AUIS.  A World Wide 
Web home page can be found at 
http://www.cs.cmu.edu:8001:/afs/cs.cmu.edu/project/atk-ftp/web/andrew-home.h\
tml.  A book, \italic{Multimedia Application Development with the Andrew 
Toolkit}, has been published by Prentice-Hall (ISBN 0-13-036633-1).  An 
excellent tutorial is available from the Consortium by sending mail to 
info-andrew-request@andrew.cmu.edu and asking about the manual, \italic{A 
User's Guide to AUIS}.


\heading{About the Author, Terry Gliedt}


\begindata{image,755840}
format: gif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\enddata{image, 755840}
\view{imagev,755840,5,0,0}

After spending over twenty years with IBM, Terry left Big Blue last year. 
 Although he has worked with Un*x and AUIS for over six years, he is a 
relative new-comer to Linux.  Terry does contract programming, teaches 
classes in C/C++ and Unix and writes the occasional technical document. 
 You can reach him at \italic{Software Toolsmiths}, (507) 356-4710 or by 
e-mail at \bold{tpg@mr.net}.


\enddata{text,756864}
