@make (slides)
@begin(format)

@newpage
@MajorHeading(Automatic Recognition)

@begin(itemize)
Trainable by a few examples per gesture

Application independent

Fast, accurate, efficient recognition

Fast training and retraining

Allows some gestures to vary in
size, orientation, and dynamics

Single path or multiple paths

Extensible

Eager recognition

@end(itemize)

@newpage

@MajorHeading(Why paths?)

@begin(itemize)
Paths capture motion

Paths are higher level than snapshots

Paths are computationally tractable

There will be fewer paths than snapshots
@end(itemize)

@newpage

@MajorHeading(Why these features?)

Initial criteria:
@begin(itemize)
Features should be meaningful

Features should be incrementally computable
@end(itemize)

Feature evolution:
@begin(itemize)
Started with simple set
@begin(itemize)
initial angle

bounding box size and angle

First point to last point size and angle
@end(itemize)


Tried them on sample gesture sets:
@begin(itemize)
	GDP

	Alphabet
@end(itemize)

Added features to help discrimination:
@begin(itemize)
Count of sharp angles to discriminate U & V

Path length
@end(itemize)

Discovered normality criteria:
@begin(itemize)
angles => quadrature

sharp angle count => continuous sharpness
@end(itemize)

Added dynamic features:
@begin(itemize)
path duration

maximum velocity
@end(itemize)

Possible future additions:
@begin(itemize)
Angle locations (sum of @i[ p @g(Q)@-(p) / P])

Final angle sine and cosine

Modification to initial angle features

Combinations of existing features
@end(itemize)

@end(itemize)
@newpage
@MajorHeading(Why single-stroke gestures?)
@begin(itemize)
Buxton's tension and closure ideal: physical tension corresponds to
mental tension

Segmentation avoided

Shorter timeouts

Natural two-phase paradigm

Natural eager recognition
@end(itemize)
@newpage
@MajorHeading(Gestures vs Handwriting)

Two-dimensional, single-path, multi-stroke gesture
recognition is similar to on-line handwriting
recognition, but:

@begin(itemize)
Gestures many be two, three, or more dimensions

Gestures may be multi-path

Gestures specify an operation, operand, and parameters

Buxton's chunking and phrasing again

Gestures may vary in size and orientation

Gestures have a dynamic component

@end(itemize)

@newpage
@MajorHeading(Adapting to the user)
@begin(itemize)
Some features (e.g. path duration) probably will change with experience

Add all gestures not ``undone'' to training set

``Scroll off'' old examples

Get those last hard percentage points

Can immediately incrementally update means & per-class covariances

Could use new means and old common covariance estimate to compute new weights

(Approximate) incremental inverse update possible

Recompute weights when convenient

Incorporate @i[a priori] probabilities, too.

User may unintentionally skew example set (for example, remove size
or orientation variability)

@end(itemize)

@newpage
@MajorHeading(Detecting ambiguous classes)
@begin(itemize)
Classify training examples

``All but one'' evaluation

Mahalanobis distance between each class mean
(already done during multi-path training)

Automatically use additional features from a ``feature library''
for disambiguation.
@end(itemize)

@newpage

@MajorHeading(Why not Ledeen?)

@begin(itemize)
Want to emphasize difference between gesture recognition and
character recognition

Size and orientation variable or specific

Dynamic features such as drawing time or max speed

Small training sets and fast training time

Extensible set of features

Applicability to something other than positions, e.g. forces, 3D, etc.

Have attributes to use as parameters in operations

dictionary sizes proportional to the function of the number
of training examples.

Can handle large gestures (Ledeen has max counts).

Support for eager recognition
@end(itemize)
	
@newpage
@begin(comment)
@MajorHeading()
@newpage
@MajorHeading()
@newpage
@MajorHeading()
@newpage
@MajorHeading()
@newpage
@MajorHeading()
@newpage
@MajorHeading()
@newpage
@MajorHeading()
@newpage
@MajorHeading()
@end(comment)
@end(format)

