/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: This software is part of version 7.2 of the 
 * Andrew User Interface System and is the 
 * property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * members of the Andrew Consortium with 
 * memberships extending into calendar year 
 * 1994.  This source code is not to be distributed 
 * to non-members of the consortium nor beyond 
 * a fifty-mile radius from the membership address.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
*/

#ifndef NORCSID
#define NORCSID
static char rcsid[]="$Header: /usr/user/auis-7.2/overhead/util/lib/RCS/verbose.c,v 1.6 1993/06/15 15:42:36 rr2b Exp $";
#endif

/* This file and it's functions are obsolete, and will not be compiled. The function Verbose cannot be ported to stdarg because stdarg requires at least one fixed argument.*/

#include <andrewos.h>
#include <stdio.h>
#ifdef ANSI_COMPILER
#include <stdarg.h>
#else
#include <varargs.h>
#endif

static int     *Threshold = NULL;
static unsigned int *Mask = NULL;
static char    *Prefix = NULL;
static FILE    *Stream = NULL;

void            Verbose_SetUp(stream, prefix, threshold, mask)
FILE           *stream;
char           *prefix;
int            *threshold;
unsigned int   *mask;
{
    Stream = stream;
    Prefix = prefix;
    Threshold = threshold;
    Mask = mask;
}


/*
 * How to call this function:
 *
 * Verbose([stream], [level], [bits], fmt, datum1, datum2, ..., datumN)
 *
 * Stream is given iff no stream was specified with Verbose_SetUp
 * Level is given iff a threshold was specified with Verbose_SetUp
 * Bits is given iff a mask was specified with Verbose_SetUp
 * The rest works mostly like printf, with no modifiers to the % controls
 * (no "%15s" or "%ld", etc).  This restriction is likely to change.
 */

#ifdef ANSI_COMPILER
#error "This function cannot be ported to ANSI C."
#else
int             Verbose(va_alist) va_dcl
{
    va_list         ap;
    FILE           *stream;
    int             level, numConverted = -1;
    unsigned int    bits;
    char           *fmt, *p;
    int            dint;
    double          dfloat;
    char            dchar, *dstring;
    unsigned int   duint;

    va_start(ap);

    bits = 0;
    level = 0;
    if (Stream)
        stream = Stream;
    else
        stream = va_arg(ap, FILE *);
    if (Threshold)
        level = va_arg(ap, int);
    if (Mask)
        bits = va_arg(ap, unsigned int);
    if (((!Threshold) && (!Mask))
        || (Threshold && (level <= (*Threshold)))
        || (Mask && (bits & (*Mask)))) {
        numConverted = 0;
        fmt = va_arg(ap, char *);
        if (Prefix)
            fputs(Prefix, stream);
        for (p = fmt; *p; ++p) {
            if ((*p) == '%') {
                switch (*(++p)) {
                    case 'd':
                        dint = va_arg(ap, int);
                        fprintf(stream, "%d", dint);
                        ++numConverted;
                        break;
                    case 'o':
                        dint = va_arg(ap, int);
                        fprintf(stream, "%o", dint);
                        ++numConverted;
                        break;
                    case 'x':
                        dint = va_arg(ap, int);
                        fprintf(stream, "%x", dint);
                        ++numConverted;
                        break;
                    case 'X':
                        dint = va_arg(ap, int);
                        fprintf(stream, "%X", dint);
                        ++numConverted;
                        break;
                    case 'f':
                        dfloat = va_arg(ap, double);
                        fprintf(stream, "%f", dfloat);
                        ++numConverted;
                        break;
                    case 'e':
                        dfloat = va_arg(ap, double);
                        fprintf(stream, "%e", dfloat);
                        ++numConverted;
                        break;
                    case 'E':
                        dfloat = va_arg(ap, double);
                        fprintf(stream, "%E", dfloat);
                        ++numConverted;
                        break;
                    case 'g':
                        dfloat = va_arg(ap, double);
                        fprintf(stream, "%g", dfloat);
                        ++numConverted;
                        break;
                    case 'G':
                        dfloat = va_arg(ap, double);
                        fprintf(stream, "%G", dfloat);
                        ++numConverted;
                        break;
                    case 'c':
                        dchar = va_arg(ap, char);
                        fputc(dchar, stream);
                        ++numConverted;
                        break;
                    case 's':
                        dstring = va_arg(ap, char *);
                        fputs(dstring, stream);
                        ++numConverted;
                        break;
                    case 'u':
                        duint = va_arg(ap, unsigned int);
                        fprintf(stream, "%u", duint);
                        ++numConverted;
                        break;
                    case '\0':
                        break;
                    default:
                        fputc(*p, stream);
                        break;
                }
            }
            else {
                fputc(*p, stream);
            }
        }
        fflush(stream);
    }

    va_end(ap);
    return (numConverted);
}
#endif
