/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: This software is part of version 7.2 of the 
 * Andrew User Interface System and is the 
 * property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * members of the Andrew Consortium with 
 * memberships extending into calendar year 
 * 1994.  This source code is not to be distributed 
 * to non-members of the consortium nor beyond 
 * a fifty-mile radius from the membership address.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
*/

#ifndef NORCSID
#define NORCSID
static char rcsid[]="$Header: /usr/user/auis-7.2/overhead/util/lib/RCS/gtime.c,v 1.5 1992/12/15 21:10:10 rr2b R6tape $";
#endif

/* gtime.c - inverse of localtime */
/*   value is unpredictable for illegal input values */


 

#include <andrewos.h> /* sys/time.h sys/types.h */

static int dmsize[12] = {31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

#define FEBRUARY_P(m) ((m)==1)
/* Gregorian definition: */
#define LEAPYEAR_P(y) (  ((y)%4==0) && ((((y)%100) != 0) || (((y)%400) == 0)))
/* Used only in a relative sense */
#define LEAPDAYS_SINCE(y) ( (y)/4 - (y)/100 + (y)/400 )

/* return inverse of local time */

#if defined(_POSIX_SOURCE) || defined(_IBMR2)
time_t gtime(ct)
register struct tm *ct;
{
    return (mktime(ct));
}
#else /* _POSIX_SOURCE */
time_t gtime(ct)
register struct tm *ct;
{
    time_t copyt;
    register int day;
    register int month;
    register int year;
    static int init = 0;

    /* this part is the inverse of gmtime */

    year = ct->tm_year + 1900;
    month = ct->tm_mon;
    day = ct->tm_mday - 1;
    if (month >= 12)
	month = 11;
    while (month-- > 0)
      day += ((FEBRUARY_P(month) && LEAPYEAR_P(year)) ? 29 : dmsize[month]);
    /* The following calculation is broken for the year 2100: */
    day += (year - 1970) * 365 + (((year - 1901) / 4) - 17);
    /* here's the fix:
    day += ( ((year)*356 + LEAPDAYS_SINCE(year))
           - (1970*356 + LEAPDAYS_SINCE(1970)) ); */
    copyt = ct->tm_sec + 60 * (ct->tm_min + 60 * (ct->tm_hour + 24 * (int)day));

    /* this inverts the dst adjustment in localtime */

    if (init == 0) {
	osi_SetZone();
	init = 1;
    }
    if (osi_IsEverDaylight && ct->tm_isdst)
	copyt -= 60*60;
    return (copyt + (time_t)osi_SecondsWest);
}
#endif /* _POSIX_SOURCE */

#ifdef TESTINGONLYTESTING
#include <stdio.h>
main()
{
  struct tm *ct;
  unsigned int int the_time, parsed_time;

  the_time = osi_GetSecs();
  ct = localtime(&the_time);
  parsed_time = (int int) gtime(ct);
  printf("The time is %ld, parsed time is %ld.\n", the_time, parsed_time);
  if (the_time != parsed_time) printf("And they are DIFFERENT!  (by a factor of %ld)\n", the_time - parsed_time);
}
#endif /* TESTINGONLYTESTING */
