/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: This software is part of version 7.2 of the 
 * Andrew User Interface System and is the 
 * property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * members of the Andrew Consortium with 
 * memberships extending into calendar year 
 * 1994.  This source code is not to be distributed 
 * to non-members of the consortium nor beyond 
 * a fifty-mile radius from the membership address.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
*/

#ifndef NORCSID
#define NORCSID
static char rcsid[]="$Header: /usr/user/auis-7.2/overhead/util/lib/RCS/getla.c,v 2.19 1994/09/02 18:08:31 rr2b Exp $";
#endif


 

#include <andyenv.h>
#include <system.h>
#include <fdplumb.h>
#include <sys/ioctl.h>
#include <sys/param.h>
#include <nlist.h>

#if defined(ultrix) && defined(mips)
#include <sys/fixpoint.h>
#endif

#ifdef NeXT
double getla(index)
int index;
{
    return (double) 0.0;
}
#else /* NeXT */

static struct nlist Nl[] =
{
#ifdef PMAX_ENV
	{ "avenrun" },
#else /* PMAX_ENV */
	{ "_avenrun" },
#endif /* PMAX_ENV */
#define	X_AVENRUN	0
	{ 0 },
};

static int kmem = -1, fpastate = -1, fpacount = 0;

double getla(index)
int index;
{
#ifdef sun
    int avenrun[3];	/* For any kind of sun */
#else /* sun */
#if defined(ultrix) && defined(mips)
    fix avenrun[3];
#else /* mips & ultrix */
    double avenrun[3];
#endif /* mips & ultrix */
#endif /* sun */

    if (kmem < 0) {
	kmem = open("/dev/kmem", O_RDONLY, 0);
	if (kmem < 0) return -1.0;
#ifdef FIOCLEX
	(void) ioctl(kmem, FIOCLEX, 0);
#endif /* FIOCLEX */
	nlist("/vmunix", Nl);
	if (Nl[0].n_type == 0) {
	    close(kmem);
	    kmem = -1;
	    return -1.0;
	}
    }
    if (fpastate < 0 || (fpastate > 0 && fpacount <= 0)) {
	fpastate = (fpacheck() == 0 ? 1 : 0);
	fpacount = 100;	/* Check it every 100 calls */
    }
    if (fpacount >= 0) --fpacount;
    if (fpastate <= 0) return -1.0;	/* Default if the FPA is bad. */

    if (lseek(kmem, (int) Nl[X_AVENRUN].n_value, 0) == -1 ||
	 read(kmem, avenrun, sizeof(avenrun)) < sizeof(avenrun)) return -1.0;

#ifdef SUN_ENV
#ifdef MACH
#define FSCALE (1<<8)
#endif
    return (double) avenrun[index] / FSCALE;
#else /* SUN_ENV */
#if defined(mips) && defined(ultrix)
    return FIX_TO_DBL(avenrun[index]);
#else /* mips & ultrix */
    return avenrun[index];
#endif /* mips & ultrix */
#endif /* SUN_ENV */
}
#endif /* NeXT */

getla_ShutDown()
{
#ifndef NeXT
    if (kmem >= 0) {
	close(kmem);
	kmem = -1;
    }
#endif
}
