/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: This software is part of version 7.2 of the 
 * Andrew User Interface System and is the 
 * property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * members of the Andrew Consortium with 
 * memberships extending into calendar year 
 * 1994.  This source code is not to be distributed 
 * to non-members of the consortium nor beyond 
 * a fifty-mile radius from the membership address.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
*/

#ifndef NORCSID
#define NORCSID
static char rcsid[]="$Header: /usr/user/auis-7.2/overhead/util/lib/RCS/gethome.c,v 2.10 1993/09/21 18:37:04 rr2b Exp $";
#endif


 
#include <andrewos.h>
#include <pwd.h>
#include <stdio.h>
#include <errno.h>
#include <util.h>

#ifndef NULL
#define NULL 0
#endif

extern char *getenv();

extern int errno;

static char home[100]="";

char *gethome(name)
char *name;
{
    struct passwd *pw=NULL;
    char *h=NULL;

    if (name==NULL) {
	if(home[0]!='\0')
	    return home;

	h=getenv("HOME");

	/* Do not trust env vbl HOME if it is "/" because we
	    may be spawned by the guardian -- nsb */
	if(h==NULL || strcmp(h,"/")==0) {
	    pw = getpwuid(getuid());
	    if (pw != NULL) h = pw->pw_dir;
	}
	if (h != NULL) strncpy(home, h, sizeof(home));
    } else {
	errno = 0;
	pw=getpwnam(name);
	if (pw != NULL) h = pw->pw_dir;
    }

    return h;
}
#ifdef TESTINGONLYTESTING
main()
{
    char Buf[500], *Ques, *Ans;

    for (;;) {
	printf("home dir of: "); fflush(stdout);
	if (gets(Buf) == NULL) exit(0);
	Ques = Buf[0] == '\0' ? NULL : Buf;
	Ans = gethome(Ques);
	printf("gethome(\"%s\") returns ``%s''.\n",
	       Ques == NULL ? "NULL" : Ques,
	       Ans == NULL ? "NULL" : Ans);
    }
}
#endif /* TESTINGONLYTESTING */
