/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: This software is part of version 7.2 of the 
 * Andrew User Interface System and is the 
 * property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * members of the Andrew Consortium with 
 * memberships extending into calendar year 
 * 1994.  This source code is not to be distributed 
 * to non-members of the consortium nor beyond 
 * a fifty-mile radius from the membership address.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
*/

#ifndef NORCSID
#define NORCSID
static char rcsid[]="$Header: /usr/user/auis-7.2/overhead/util/lib/RCS/fselect.c,v 2.13 1994/01/30 05:37:19 rr2b Exp $";
#endif

#include <andrewos.h>		/* sys/time.h */
#include <stdio.h>

static int NOFILES=(-1);

int fselect(nfds, rfiles, wfiles, xfiles, timeout)
int	nfds;
FILE	**rfiles, **wfiles, **xfiles;
struct timeval	*timeout;
{
    fd_set rmask, wmask, xmask;
    int ret=0;
    register int	i;

    FD_ZERO(&rmask);
    FD_ZERO(&wmask);
    FD_ZERO(&xmask);
    if (NOFILES < 0) {
	NOFILES = FDTABLESIZE();
    }
    for (i = nfds; --i >= 0;) {
	register int fd;
	if (rfiles && rfiles[i] != NULL && (fd = fileno(rfiles[i])) >= 0 && fd < NOFILES) 
	    if (FILE_HAS_IO(rfiles[i]) > 0)
		ret++;
	    else
		FD_SET(fd, &rmask);
	if (wfiles && wfiles[i] != NULL && (fd = fileno(wfiles[i])) >= 0 && fd < NOFILES)
	    FD_SET(fd, &wmask);
	if (xfiles && xfiles[i] != NULL && (fd = fileno(xfiles[i])) >= 0 && fd < NOFILES)
	    FD_SET(fd, &xmask);
    }
    if (ret==0) 
	ret = select(NOFILES, &rmask, &wmask, &xmask, timeout);
    else {
	FD_ZERO(&rmask);
	FD_ZERO(&wmask);
	FD_ZERO(&xmask);
    }
    for (i = nfds; --i >= 0;) {
	if (rfiles && rfiles[i] != NULL &&
	    FILE_HAS_IO(rfiles[i]) <= 0 &&
	    (!FD_ISSET(fileno(rfiles[i]), &rmask)))
	    rfiles[i] = NULL;
	if (wfiles && wfiles[i] != NULL && (!FD_ISSET(fileno(wfiles[i]), &wmask)))
	    wfiles[i] = NULL;
	if (xfiles && xfiles[i] != NULL && (!FD_ISSET(fileno(xfiles[i]), &xmask)))
	    xfiles[i] = NULL;
    }
    return (ret);
}
