%{

/***********************************************************
		Copyright IBM Corporation 1991

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the name of IBM not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

IBM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
IBM BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

***********************************************************/

/*
	$Disclaimer: This software is part of version 7.2 of the 
 * Andrew User Interface System and is the 
 * property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * members of the Andrew Consortium with 
 * memberships extending into calendar year 
 * 1994.  This source code is not to be distributed 
 * to non-members of the consortium nor beyond 
 * a fifty-mile radius from the membership address.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
*/

/*
		Lexical analyzer for address parsing.
*/

#include <andrewos.h>
#include <parseadd.h>
#include "parsey.h"

#define NIL	0

typedef unsigned char bool;
#define FALSE	0
#define TRUE	1

extern char *StrCopy();
static bool EatComment(), GetString(), GetDomainLit();

YYSTYPE yylval;

#if 0
#if !defined(hp9000s300) && !defined(__alpha) && !defined(_IBMR2)
#ifdef FLEX_ENV
extern char *yytext;
#else
extern char yytext[];
#endif
#endif
#endif

int pareset_lexer() { return 0;}

static char *CurrentLine, *CurrentChar, *cbuffer;

/* Chain of () comments found in address */
ADDRESS_COMMENT *yycomments, *LastComment;
extern ADDRESS_COMMENT *MakeComment();

#ifdef input
static char my_input();
#undef input
#define input() my_input()
#endif

#ifdef unput
static my_unput();
#undef unput
#define unput(c) my_unput(c)
#endif

#ifdef YY_INPUT
static int my_YY_input();
#undef YY_INPUT
#define YY_INPUT(buf, result, max_size) \
    (result = my_YY_input(buf, max_size))
#endif
  
#undef YYLMAX
#define YYLMAX 400

#ifdef yywrap
#undef yywrap
#endif

%}

LWSP			[ \t]
ATOMCHARS		[!#-\'\*\+\-/-9=\?A-Z\^-~]
WORD			{ATOMCHARS}+
DWORD			({WORD}(\.{WORD})+)
ALIST			({WORD}({LWSP}+{WORD})+)
DHACK			(({WORD}\.+)|(\.+{WORD})|(\.\.+))

%%

\n{LWSP}+		|

{LWSP}+			;

\(			{
			  register ADDRESS_COMMENT *c;
			  char *s;

			  cbuffer = yytext+1;
			  if (!EatComment()) return BADTOKEN;
			  s = StrCopy(yytext);
			  if (s == NIL) return BADTOKEN;
			  c = MakeComment(s);
			  if (c == NIL) return BADTOKEN;
			  if (yycomments == NIL)
			      LastComment = yycomments = c;
			  else
			      LastComment -> Next = c;
			  LastComment = c;
			}

\"			{
			  if (GetString()) {
			      yylval.u_string = StrCopy(yytext);
			      if (yylval.u_string == NIL)
				  return BADTOKEN;
			      else
				  return QUOTEDSTRING;
			  } else
			      return BADTOKEN;
			}

\[			{
			  if (GetDomainLit()) {
			      yylval.u_string = StrCopy(yytext);
			      if (yylval.u_string == NIL)
				  return BADTOKEN;
			      else
				  return DOMAINLIT;
			  } else
			      return BADTOKEN;
			}

({WORD}{LWSP}+)*{DHACK}	{
			  yylval.u_string = StrCopy(yytext);
			  if (yylval.u_string == NIL)
			      return BADTOKEN;
			  else
			      return DOTLIST;
			}

\<			return '<';
\>			return '>';
@			return '@';
\.			return '.';
\;			return ';';
:			return ':';
\,			return ',';
\\			return '\\';

{DWORD}			{
			  yylval.u_string = StrCopy(yytext);
			  if (yylval.u_string == NIL)
			      return BADTOKEN;
			  else
			      return DOTWORD;
			}

{ALIST}			{
			  yylval.u_string = StrCopy(yytext);
			  if (yylval.u_string == NIL)
			      return BADTOKEN;
			  else
			      return ATOMLIST;
			}

{WORD}			{
		  	  yylval.u_string = StrCopy(yytext);
			  if (yylval.u_string == NIL)
			      return BADTOKEN;
			  else
			      return ATOM;
			}

.			return BADTOKEN;

%%
static char *parsel_rcsid = "$Header: /usr/user/auis-7.2/overhead/mail/lib/RCS/parsel.lex,v 2.19 1994/06/01 19:59:16 rr2b Exp $";

void SetNextLine(line)
    char *line;
{
    extern int ParseErrorReason;

    CurrentLine = line;
    CurrentChar = CurrentLine;
    yycomments = NIL;
    ParseErrorReason = PA_SYNTAX_ERROR;
}

#ifdef FLEX_ENV
  int yywrap()
  {
    /* wrap returns 1 if No buffer or at end of buffer */
    return (CurrentLine == NULL) ||
      (CurrentChar > CurrentLine && !CurrentChar[-1]); /*Yuck*/
}
#else
int yywrap()
{
      return 1;
  }
#endif
  	
#ifdef FLEX_ENV
static int my_YY_input(buf, max_size)
    char *buf;
    int max_size;
{
      register char c;
  
    *buf = c = *CurrentChar++;
    if ((c & 0x80) || c == 04)	/* High-order bit is on, or it's a ^D */
	*buf = 1;
    if (!(*buf)) return 0;
    return 1;
  }
#endif

static my_unput(c)
    char c;
{
    /* Only push back if not at beginning or end of line */
    if (CurrentChar > CurrentLine)
	*--CurrentChar = c;
}

static char my_input()
{
    register char c;

    c = *CurrentChar++;
    if ((c & 0x80) || c == 04)	/* High-order bit is on, or it's a ^D */
	return 01;
    else
	return c;
}

static bool LWSP_char(c)
    char c;
{
    return (c == ' ' || c == '\t');
}

/* Eat a comment -- returns with closing ) as current char */

static bool EatComment()
{
    char *last = yytext + YYLMAX - 2;

    /* Just ate ( */
    for (;cbuffer < last;) {
	register char c;

	c = input();
	switch (c) {
	    case 0:		return FALSE;
	    case ')':		*cbuffer++ = c;
		                *cbuffer = '\0';
		                return(TRUE);
	    case '(':		*cbuffer++ = '(';
				if (!EatComment())
				    return FALSE;
				break;
	    case '\\':		*cbuffer++ = '\\';
				c = input();
				if (c == 0) return FALSE;
				*cbuffer++ = c;
				break;
	    case '\n':		c = input();
				if (!LWSP_char(c)) return FALSE;
				do { c = input(); } while (LWSP_char(c));
				unput(c);
				*cbuffer++ = ' ';
				break;
	    default:		*cbuffer++ = c;
				break;
	}
    }
    if (cbuffer == last) {
	*cbuffer++ = ')';
	*cbuffer = '\0';
	return(TRUE);
    }
}

/*
   Read a quoted string -- leaves closing quote as current char.
*/

static bool GetString()
{
    register char *next = yytext + 1, *last = yytext + YYLMAX - 2;

    /* Already seen " */
    for (; next < last ; ) {
	register char c;

	c = input();
	switch (c) {
	    case 0:	return FALSE;
	    case '"':	*next++ = '"';
			*next = '\0';
			return TRUE;
	    case '\\':	*next++ = '\\';
			c = input();
			if (c == 0) return FALSE;
			*next++ = c;
			break;
	    case '\n':	c = input();
			if (!LWSP_char(c)) return FALSE;
			do { c = input(); } while (LWSP_char(c));
			*next++ = ' ';
			unput(c);
			break;
	    default:	*next++ = c;
			break;
	}
    }
    if (next == last) {
	*next++ = '"';
	*next = '\0';
	return(TRUE);
    }
}

/*
   Read a domain literal leaves closing quote as current char.
*/

static bool GetDomainLit()
{
    register char *next = yytext + 1, *last = yytext + YYLMAX - 2;

    /* Already seen [ */
    for (; next < last ; ) {
	register char c;

	c = input();
	switch (c) {
	    case 0:
	    case '[':		return FALSE;
	    case ']':		*next++ = ']';
				*next = '\0';
				return TRUE;
	    case '\\':		c = input();
				if (c == 0) return FALSE;
				*next++ = c;
				break;
	    case '\n':		c = input();
				if (!LWSP_char(c)) return FALSE;
				do { c = input(); } while (LWSP_char(c));
				*next++ = ' ';
				unput(c);
				break;
	    default:		*next++ = c;
				break;
	}
    }
    if (next == last) {
	*next++ = ']';
	*next = '\0';
	return TRUE;
    }
}
