/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: This software is part of version 7.2 of the 
 * Andrew User Interface System and is the 
 * property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * members of the Andrew Consortium with 
 * memberships extending into calendar year 
 * 1994.  This source code is not to be distributed 
 * to non-members of the consortium nor beyond 
 * a fifty-mile radius from the membership address.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
*/

#ifndef NORCSID
#define NORCSID
static char rcsid[]="$Header: /usr/user/auis-7.2/overhead/index/RCS/rcordset.c,v 2.9 1993/06/30 05:04:24 rr2b Exp $";
#endif

#include <andrewos.h> /* sys/types.h sys/file.h */
#include <stdio.h>

#include "index.h"

/*
 * Internal routine: return a new, empty hash list.  Empty hash lists are not represented
 * by null pointers, but rather a hash list with a zero entry count.
 */
struct hashList *index_NewHL()
{
    register struct hashList *th;
    th = (struct hashList *) malloc (sizeof (struct hashList));
    th->next = (struct hashList *) 0;
    th->nentries = 0;
    return th;
}

/*
  * Internal routine: given a hash list and a hash value, return true if the value is
      * contained in the list, and false otherwise.
      */
index_HashPresent(alist, ahash)
register struct hashList *alist;
register int ahash;
{
    register int i;
    for(;alist;alist=alist->next) {
	for(i=0;i<alist->nentries;i++) {
	    if (ahash == alist->entries[i]) return 1;
	}
    }
    return 0;
}

/*
  * Internal routine: given a hash list and a hash value, delete the value from
  * the hash list.
  */
index_HashRemove(alist, ahash)
register struct hashList *alist;
register int ahash;
{
    register int i;
    for(;alist;alist=alist->next) {
	for(i=0;i<alist->nentries;i++) {
	    if (ahash == alist->entries[i]) alist->entries[i] = 0xffff;
	}
    }
    return 0;
}

/*
  * Internal routine: given a hash list and a hash value, add the value to the list.
  */
index_HashAdd(alist, ahash)
register struct hashList *alist;
register int ahash;
{
    register struct hashList *tlist;
    for(tlist=alist;tlist;tlist=tlist->next) {
	if (tlist->nentries < MAXHL) {
	    tlist->entries[tlist->nentries++] = ahash;
	    return;
	}
    }
    tlist = (struct hashList *) malloc(sizeof(struct hashList *));
    tlist->nentries = 1;
    tlist->next = alist->next;
    alist->next = tlist;
    tlist->entries[0] = ahash;
}

/*
  * Internal routine: given a hash list, free it.
  */
index_FreeHL(alist)
register struct hashList *alist;
{
    register struct hashList *next;
    for(;alist;alist=next) {
	next = alist->next;
	free(alist);
    }
}

/*
  * Create a new, empty record set.
  */
struct recordSet *recordset_New(asize)
{
    register struct recordSet *tr;
    if (asize <= 0) asize = 1;
    tr = (struct recordSet *) malloc(sizeof(struct recordSet));
    tr->count = 0;
    tr->acount = asize;
    tr->data = (struct recordID *) malloc(asize * sizeof(struct recordID));
    return tr;
}

/*
  * Free a record set.
  */
void recordset_Free(aset)
register struct recordSet *aset;
{
    free(aset->data);
    free(aset);
}

/*
  * Add a record id to a record set.
  */
recordset_Add(aset, arid)
register struct recordSet *aset;
register struct recordID *arid;
{
    register int c;
    register struct recordID *tid;
    int newSize;
    for(tid=aset->data,c=0; c<aset->count; tid++,c++) {
	if (req(*tid, *arid)) return;
    }
    c = aset->count;
    if (c>= aset->acount) {
	newSize = 2*c;
	aset->data = (struct recordID *) realloc(aset->data, newSize*sizeof(struct recordID));
	aset->acount = newSize;
    }
    rset(aset->data[c], *arid);
    aset->count = c+1;
}

/* more recordset operations to come as they become necessary */
