#ifndef _andrew_index_h_
#define _andrew_index_h_
 /* C++ified by magic !@#%&@#$ */
#include <atkproto.h>
BEGINCPLUSPLUSPROTOS
/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: This software is part of version 7.2 of the 
 * Andrew User Interface System and is the 
 * property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * members of the Andrew Consortium with 
 * memberships extending into calendar year 
 * 1994.  This source code is not to be distributed 
 * to non-members of the consortium nor beyond 
 * a fifty-mile radius from the membership address.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
*/


 

/*
 * here are the various record headers.  Records come in two major types, the 
 * primary records, which consist of an IPrimary subrecord, an IBucketList subrecord
 * and an IData subrecord, in that order, and a secondary record, consisting of an
 * ISecondary subrecord.
 
 * An IPrimary record is followed by an 8 byte UID, and a null-terminated keyword.
 * A bucket-list is followed by an array of 16 bit (network byte order, kiddies)
 * integers, terminated by an 0xffff entry.
 * An IData subrecord is followed by an uninterpreted null-terminated byte string.

 * Note that no byte strings, keys or names may contain any characters
 * less than or equal to IMax.
 
 * The database itself is comprised of a dir full of two types of files.  One file, named
 * V<version number>.<hash-table size> describes the version number and hash
 * table size.  The others, named H<number> contain the various hash buckets.
 * Each hash bucket contains a set of primary and secondary records whose keys
 * hash to the appropriate bucket.
 */

#define MAXSTRLENGTH		1024		/* max string size */
#define INDEXVERSION		1

struct recordID {
    int word1;		/* hash value */
    int word2;		/* counter */
};

#define IPRIMARY			1
#define IBUCKETLIST		2
#define IDATA			3

#define ISECONDARY		8
/* leave 9 unused, it is a tab */

#define IMAX				26

struct Index {
    int version;
    char *pathName;
    short hashTableSize;
    struct indexBucket *blist;
};

#define MAXHL		10
struct hashList {
    struct hashList *next;
    int nentries;
    short entries[MAXHL];
};

struct indexBucket {
    struct indexBucket *next;
    int hashIndex;
    int nextID;
    struct indexComponent *list;
    char modified;
};

struct indexComponent {
    struct indexComponent *next;
    char *name;
    struct hashList *hashes;
    struct recordID id;
    char *data;
    char primary;				/* true iff primary record */
};

#define INDEXOK			0
#define INDEXNOVERSION	(-1)
#define IBADV			(-2)
#define INDEXNOENT		(-3)

#define rset(a,b) (a).word1 = (b).word1; (a).word2 = (b).word2;
#define req(a,b) ((a).word1 == (b).word1 && (a).word2 == (b).word2)
#define rhash(a) (a).word1

struct recordSet {
    int count;				/* in-use slots */
    int acount;				/* allocated slots */
    struct recordID *data;
};

typedef void (*index_efptr)(struct Index *ai, struct indexComponent *tc, char *arock);
extern struct indexBucket *index_CGet(struct Index  *ai, register char  *akey);
extern struct hashList *index_NewHL();
extern struct indexComponent *index_FindID(register struct indexBucket  *ab, register struct recordID  *arid);
extern FILE *index_HashOpen(register struct Index  *ai, register int  ahash, register int  awrite);
extern struct Index *index_Open(register char  *apath);
extern void index_Close(struct Index *ai);
extern struct recordSet *index_GetPrimarySet(register struct Index  *ai, register char  *akey);
extern struct recordSet *index_GetAnySet(register struct Index  *ai, register char  *akey);
extern struct indexBucket *index_ReadIndex(register FILE  *afile);
extern struct indexBucket *index_CGetHash(struct Index  *ai, register int  ahash);
extern struct indexBucket *index_CGet(struct Index  *ai, register char  *akey);
extern struct recordSet *recordset_New(int asize);
extern int index_Hash(register char  *astring, register int  hashSize);
void index_Enumerate(struct Index *ai, index_efptr aproc, char *arock);
int index_GetData(struct Index *ai, struct recordID *arid, char *abuffer, int alen);
void recordset_Free(struct recordSet *aset);
ENDCPLUSPLUSPROTOS
 
#endif
