/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: This software is part of version 7.2 of the 
 * Andrew User Interface System and is the 
 * property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * members of the Andrew Consortium with 
 * memberships extending into calendar year 
 * 1994.  This source code is not to be distributed 
 * to non-members of the consortium nor beyond 
 * a fifty-mile radius from the membership address.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
*/

#ifndef NORCSID
#define NORCSID
static char rcsid[]="$Header: /usr/user/auis-7.2/overhead/eli/lib/RCS/errnode.c,v 2.8 1992/12/15 21:01:25 rr2b R6tape $";
#endif

#include <errnode.h>

void            eliErr_Set(st, e, code, node, loc, unixerr)
EliState_t     *st;
eliErrStuff_t  *e;
int             code;
EliSexp_t      *node;
char           *loc;
{
    EliSexp_t      *tmp = e->badnode;

    e->errnum = code;
    e->badnode = node;
    e->errloc = loc;
    e->unixerr = unixerr;
    if (node)
	eliSexp_IncrRefcount(node);
    if (tmp)
	eliSexp_DecrRefcount(st, tmp);
}

int eliErr_GetUnixErr(e)
eliErrStuff_t *e;
{
    return (e->unixerr);
}

int             eliErr_GetCode(e)
eliErrStuff_t  *e;
{
    return (e->errnum);
}

EliSexp_t      *eliErr_GetNode(e)
eliErrStuff_t  *e;
{
    return (e->badnode);
}

EliCons_t *eliErr_GetBacktrace(e)
eliErrStuff_t *e;
{
    return (e->backtrace);
}

char           *eliErr_GetLoc(e)
eliErrStuff_t  *e;
{
    return (e->errloc);
}

int             eliErr_SexpP(e)
eliErrStuff_t  *e;
{
    return ((e->badnode) != NULL);
}

void            eliErr_Init(e)
eliErrStuff_t  *e;
{
    e->badnode = NULL;
    e->backtrace = NULL;
}
