#ifndef ATKSYMTAB
#define ATKSYMTAB 1
/* Copyright 1994 Carnegie Mellon University All rights reserved.
  $Disclaimer: This software is part of version 7.2 of the 
 * Andrew User Interface System and is the 
 * property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * members of the Andrew Consortium with 
 * memberships extending into calendar year 
 * 1994.  This source code is not to be distributed 
 * to non-members of the consortium nor beyond 
 * a fifty-mile radius from the membership address.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
*/

// ATKSymTab: a hash table containing symbol names.
// Typical use will be in collecting the set of import or export
// filenames used by a dynamic object or executable.
// Deletion will not be supported.
// Supported operations will be:
// boolean AddSymbol(char *) returns TRUE iff the
// symbol was successfully added.
// boolean FindSymbol(char *) returns TRUE iif the
// symbol was found.

#include <andrewos.h>

// ATKSymList: used internally by ATKSymtab to contain
// the contents of each bucket.
class ATKSymList {
  private:
    static const int BumpSize;
    char *syms;
    int size;
    int used;
    int extra;
  public:
    ATKSymList();
    ATKSymList(int extra);
    ~ATKSymList();
    void *AddSymbol(const char *sym);
    void *FindSymbol(const char *sym);
    void ResetIterator();
    char *NextSymbol();
    void SetExtra(int ex);
};
    
class ATKSymTab {
  private:
    static const int HashSize;
    ATKSymList *sl;
    int Hash(const char *sym);
  public:
    ATKSymTab();
    ATKSymTab(int extra);
    ~ATKSymTab();
    void *AddSymbol(const char *sym);
    void *FindSymbol(const char *sym);
    void ResetIterator();
    char *NextSymbol();
};

#endif /* ATKSYMTAB */
