/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: This software is part of version 7.2 of the 
 * Andrew User Interface System and is the 
 * property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * members of the Andrew Consortium with 
 * memberships extending into calendar year 
 * 1994.  This source code is not to be distributed 
 * to non-members of the consortium nor beyond 
 * a fifty-mile radius from the membership address.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
*/

#ifndef NORCSID
#define NORCSID
static char rcsid[]="$Header: /usr/user/auis-7.2/overhead/cmenu/RCS/scache.c,v 1.7 1994/06/09 18:02:58 rr2b Exp $";
#endif


/* This file (scache.c) and scache.h will implement a string cacheing mechanism so that even if menus are leaked they won't represent much of a drain... */

#include <stdio.h>
#include "scache.h"

static struct scache_node scache[256];

#define HASH(str,len) (((*(str)<<2)+((str)[(len)>>1])+((str)[(len)-(len)?1:0]<<2)+((str)[len>>2]<<2)+(len))&0xff)
#define BLOCKSIZE 5
#define GROWTHFACTOR 2

void scache_Init()
{
    memset(scache,0, sizeof(scache));
}

char *scache_Hold(str)
char *str;
{
    unsigned int len;
    unsigned int hash;
    struct scache_node *s;
    struct scache_el *e=NULL;

    if(!str) str="";
    
    len=strlen(str);
    hash=HASH(str,len);
    s=scache+hash;

    if(s->els) {
	int i;
	struct scache_el **p=s->scache_el;
	for(i=0;i<s->els;i++, p++) {
	    if(!strcmp((*p)->str, str)) {
		(*p)->refcount++;
		return (*p)->str;
	    }
	    if((*p)->refcount<=0) e=(*p);
	}
    }
    if(!e) {
	if(s->els>=s->maxels) {
	    s->maxels=s->maxels*GROWTHFACTOR+BLOCKSIZE;
	    if(s->scache_el) s->scache_el=(struct scache_el **)realloc(s->scache_el, s->maxels*sizeof(struct scache_el *));
	    else s->scache_el=(struct scache_el **)malloc(s->maxels*sizeof(struct scache_el *));
	    if(!s->scache_el) {
		s->els=0;
		s->maxels=0;
		return NULL;
	    }
	}
	e=(struct scache_el *)malloc(len+sizeof(struct scache_el));
	if(!e) return NULL;
	s->els++;
    } else e=(struct scache_el *)realloc(e, len+sizeof(struct scache_el));
    s->scache_el[s->els-1]=e;
    strcpy(e->str,str);
    e->refcount=1;
    return e->str;
}

void scache_Free(str)
char *str;
{
    scache_REFCOUNT(str)--;
}

void scache_Dump()
{
    int i;
    printf("doing scache dump\n");
    for(i=0;i<256;i++) {
	printf("------\n");
	if(scache[i].els) {
	    int j;
	    for(j=0;j<scache[i].els;j++) printf("%s\n",scache[i].scache_el[j]->str);
	}
    }
}
