/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
	$Disclaimer: This software is part of version 7.2 of the 
 * Andrew User Interface System and is the 
 * property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * members of the Andrew Consortium with 
 * memberships extending into calendar year 
 * 1994.  This source code is not to be distributed 
 * to non-members of the consortium nor beyond 
 * a fifty-mile radius from the membership address.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
\* ********************************************************************** */
#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *toksym_ch_rcsid = "$Header: /usr/user/auis-7.2/overhead/c++conv/chfiles/RCS/toksym.ch,v 1.1 1993/10/13 15:52:18 rr2b Exp $";
#endif

/* toksym.ch
 *
 * A toksym object is a subclass of sym.  Its adds four fields:
 *	toknum	-  the token number for compiler
 *	loc, len 	-  position of the token in the source stream
 *	info	-  type dependant information
 *
 */

/*
 *    $Log: toksym.ch,v $
 * Revision 1.1  1993/10/13  15:52:18  rr2b
 * installing the old ch files for converting code
 *
*Revision 1.11  1993/05/04  01:34:45  susan
*RCS Tree Split
*
*Revision 1.10.1.1  1993/02/02  04:13:40  rr2b
*new R6tape branch
*
*Revision 1.10  1992/12/14  20:58:22  rr2b
*disclaimerization
*
Revision 1.9  1992/11/26  02:03:49  wjh
updated header
.

... 
 * Revision 1.0  88/07/13  20:50:00  WJHansen
 * Copied from sym.H
 */


#include "sym.ih"	
/* This include generates an error message claiming that sym.ih is included twice.  
   The conflict is with the include generated by class as part of toksym.ih, but
   the automatically generated include does NOT define the routines. */


/* the following doesn't work !?!?! */
/*	typedef sym_scopeType  toksym_scopeType;   */

typedef  long   toksym_scopeType;

#define toksym_GLOBAL sym_GLOBAL


union infotype {
	long intval;
	double *realval;
	char *str;
	long (*proc)();
	struct object *obj;
	struct node *node;
};


class toksym : sym
{
methods:

	ToC(/*struct toksym *self, */ struct text *t, char *buf, long maxlen) returns char *;
		/* copies the token from the text to the buffer, up to maxlen bytes
			returns buf */

macros:

/* the initial T in each of these procedure names is to get around a bug in the class system */

	TNewScope(enclosingScope) ((toksym_scopeType)sym_NewScope(enclosingScope))
	TDestroyScope(scope) (sym_DestroyScope(scope))
	TParentScope(scope) ((toksym_scopeType)sym_ParentScope(scope))
	TDefine(name, proto, scope) ((struct toksym *)sym_Define(name, proto, scope))
	TUndefine(name, scope) (sym_Undefine(name, scope))
	TFind(name, scope) ((struct toksym *)sym_Find(name, scope))
	TLocate(name, proto, scope, new) ((struct toksym *)sym_Locate(name, proto, scope, new))
	TFindAll(name, scope, proc, rock) (sym_FindAll(name, scope, proc, rock))

macromethods:

	TGetName()	((self)->header.sym.name)
	TGetScope()	((toksym_scopeType)(self)->header.sym.scope)
	GetLoc()		((self)->loc)
	GetLen()		((self)->len)

classprocedures:

	InitializeObject(/* struct classhdr *ClassID, */ struct toksym *self) returns boolean;
	FinalizeObject(/* struct classhdr *ClassID, */ struct toksym *self);

data:

	short toknum;	/* token code for yacc */
	long loc, len;	/* position of token in source */
	union infotype info;	/* type dependent */

};

